/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.processor.BaseProcessorExtension;
import org.springframework.util.CollectionUtils;

public class DocumentUrlResolver
extends BaseProcessorExtension
implements TemplateMethodModelEx {
    private final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^}]+)}");

    public Object exec(List list) throws TemplateModelException {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        Object arg0 = list.get(0);
        String propertyKey = null;
        if (arg0 instanceof SimpleScalar) {
            propertyKey = ((SimpleScalar)arg0).getAsString();
        }
        return this.resolvePropertyValue(propertyKey, list.subList(1, list.size()).toArray());
    }

    public Object get(String message, Object ... args) {
        return this.resolvePropertyValue(message, args);
    }

    private String resolvePropertyValue(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        String resolved = this.resolvePlaceHolders(message);
        if (args != null && args.length > 0) {
            return MessageFormat.format(resolved, args);
        }
        return resolved;
    }

    private String resolvePlaceHolders(String message) {
        Matcher matcher = this.PLACEHOLDER_PATTERN.matcher(message);
        StringBuffer result = new StringBuffer();
        boolean replaced = false;
        while (matcher.find()) {
            Object replacement;
            String key = matcher.group(1);
            String value = I18NUtil.getMessage((String)key);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                replacement = this.resolvePlaceHolders(value);
                replaced = true;
            } else {
                replacement = "${" + key + "}";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement((String)replacement));
        }
        matcher.appendTail(result);
        return replaced ? this.resolvePlaceHolders(result.toString()) : result.toString();
    }
}

