/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.web.config.header.HeaderItemsConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigException;

public class HeaderItem {
    private static final long serialVersionUID = -8543180919661884269L;
    private static final String ATTR_ID = "id";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_PERMISSION = "permission";
    private static final String ATTR_CONDITION = "condition";
    private static Log logger = LogFactory.getLog(HeaderItem.class);
    private String generatedId;
    private String text;
    private final Map<String, String> attributes;
    private Map<String, HeaderItemsConfigElement> containers = new LinkedHashMap<String, HeaderItemsConfigElement>();

    public HeaderItem(String id, Map<String, String> attributes) {
        this(id, attributes, null);
    }

    public HeaderItem(String generatedId, Map<String, String> attributes, String text) {
        if (generatedId == null) {
            String msg = "Illegal null field id";
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg);
            }
            throw new ConfigException(msg);
        }
        this.generatedId = generatedId;
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        this.attributes = attributes;
        this.text = text;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getId() {
        return this.attributes.get(ATTR_ID);
    }

    public String getType() {
        return this.attributes.get(ATTR_TYPE);
    }

    public String getIcon() {
        String icon = this.attributes.get(ATTR_ICON);
        if (icon == null) {
            icon = this.getId().concat(".png");
            this.attributes.put(ATTR_ICON, icon);
        }
        return icon;
    }

    public String getLabel() {
        String label = this.attributes.get(ATTR_LABEL);
        if (label == null) {
            label = "header.".concat(this.getId()).concat(".label");
            this.attributes.put(ATTR_LABEL, label);
        }
        return label;
    }

    public String getDescription() {
        String description = this.attributes.get(ATTR_DESCRIPTION);
        if (description == null) {
            description = "header.".concat(this.getId()).concat(".description");
            this.attributes.put(ATTR_DESCRIPTION, description);
        }
        return description;
    }

    public String getPermission() {
        String permission = this.attributes.get(ATTR_PERMISSION);
        if (permission == null) {
            permission = "";
            this.attributes.put(ATTR_PERMISSION, permission);
        }
        return permission;
    }

    public String getCondition() {
        String condition = this.attributes.get(ATTR_CONDITION);
        if (condition == null) {
            condition = "";
            this.attributes.put(ATTR_CONDITION, condition);
        }
        return condition;
    }

    public String getValue() {
        return this.text == null ? "" : this.text;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("HeaderItem: ").append(this.generatedId);
        if (this.text != null) {
            result.append(" value:").append(this.text);
        }
        return result.toString();
    }

    public HeaderItemsConfigElement[] getContainers() {
        return this.getContainersAsList().toArray(new HeaderItemsConfigElement[0]);
    }

    public List<HeaderItemsConfigElement> getContainersAsList() {
        ArrayList<HeaderItemsConfigElement> result = new ArrayList<HeaderItemsConfigElement>(this.containers.size());
        for (Map.Entry<String, HeaderItemsConfigElement> entry : this.containers.entrySet()) {
            result.add(entry.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    void addContainedItem(String containerId, HeaderItemsConfigElement container) {
        this.containers.put(containerId, container);
    }
}

