/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.header;

import java.util.ArrayList;
import org.alfresco.web.config.header.HeaderItem;
import org.alfresco.web.config.header.HeaderItemsConfigElement;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

class HeaderItemsElementReader
implements ConfigElementReader {
    public static final String ATTR_ID = "id";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_PERMISSION = "permission";
    public static final String ATTR_CONDITION = "condition";
    public static final String ELEMENT_APP_ITEMS = "app-items";
    public static final String ELEMENT_USER_ITEMS = "user-items";
    public static final String ELEMENT_CONTAINER_GROUP = "container-group";
    public static final String ELEMENT_LEGACY = "legacy-mode-enabled";
    public static final String ELEMENT_MAX_RECENT_SITES = "max-recent-sites";
    public static final String ELEMENT_MAX_DISPLAYED_SITE_PAGES = "max-displayed-site-pages";
    public static final String ID_SEPARATOR = "_";
    private String id_prefix = "";
    private String group_condition = null;
    private String group_permission = null;

    public HeaderItemsElementReader() {
    }

    public HeaderItemsElementReader(String id) {
        this.id_prefix = id == null || id.length() == 0 ? "" : id.concat(ID_SEPARATOR);
    }

    public ConfigElement parse(Element headerItemsElement) {
        HeaderItemsConfigElement result = null;
        if (headerItemsElement == null) {
            return null;
        }
        String name = headerItemsElement.getName();
        if (!(name.equals(ELEMENT_APP_ITEMS) || name.equals(ELEMENT_USER_ITEMS) || name.equals(ELEMENT_CONTAINER_GROUP) || name.equals(ELEMENT_LEGACY))) {
            throw new ConfigException(this.getClass().getName() + " can only parse app-items, user-items, container-group, legacy-mode-enabled elements, the element passed was '" + name + "'");
        }
        result = new HeaderItemsConfigElement(name);
        this.parseId(headerItemsElement, result);
        this.parseLabel(headerItemsElement, result);
        this.parseCondition(headerItemsElement, result);
        this.parsePermission(headerItemsElement, result);
        this.parseItemTags(headerItemsElement, result);
        return result;
    }

    private void parseItemTags(Element itemsElement, HeaderItemsConfigElement result) {
        for (Object itemObj : itemsElement.selectNodes("./item")) {
            Element itemElem = (Element)itemObj;
            String itemText = itemElem.getTextTrim();
            ArrayList<Attribute> itemAttributes = new ArrayList<Attribute>();
            for (Object obj : itemElem.selectNodes("./@*")) {
                itemAttributes.add((Attribute)obj);
            }
            ArrayList<String> itemAttributeNames = new ArrayList<String>();
            ArrayList<String> itemAttributeValues = new ArrayList<String>();
            String itemGeneratedId = null;
            String itemGroupCondition = this.group_condition;
            String itemGroupPermission = this.group_permission;
            for (Attribute nextAttr : itemAttributes) {
                String nextAttributeName = nextAttr.getName();
                String nextAttributeValue = nextAttr.getValue();
                if (nextAttributeName.equals(ATTR_CONDITION)) {
                    itemGroupCondition = null;
                } else if (nextAttributeName.equals(ATTR_PERMISSION)) {
                    itemGroupPermission = null;
                } else if (nextAttributeName.equals(ATTR_ID)) {
                    itemGeneratedId = this.generateUniqueItemId(nextAttributeValue);
                }
                itemAttributeNames.add(nextAttributeName);
                itemAttributeValues.add(nextAttributeValue);
            }
            if (itemGeneratedId == null) {
                throw new ConfigException("<item> node missing mandatory id attribute.");
            }
            if (itemGroupCondition != null) {
                itemAttributeNames.add(ATTR_CONDITION);
                itemAttributeValues.add(itemGroupCondition);
            }
            if (itemGroupPermission != null) {
                itemAttributeNames.add(ATTR_PERMISSION);
                itemAttributeValues.add(itemGroupPermission);
            }
            HeaderItem lastItem = result.addItem(itemGeneratedId, itemAttributeNames, itemAttributeValues, itemText);
            for (Object obj : itemElem.selectNodes("./container-group")) {
                Element containerElement = (Element)obj;
                HeaderItemsElementReader containerReader = new HeaderItemsElementReader(lastItem.getId());
                HeaderItemsConfigElement containerCE = (HeaderItemsConfigElement)containerReader.parse(containerElement);
                lastItem.addContainedItem(containerCE.getId(), containerCE);
            }
        }
    }

    private void parseId(Element itemsElement, HeaderItemsConfigElement result) {
        String id = itemsElement.attributeValue(ATTR_ID);
        if (id == null && this.id_prefix.length() > 0) {
            throw new ConfigException(itemsElement.getName() + " node missing mandatory id attribute.");
        }
        result.setId(id);
        StringBuilder sb = new StringBuilder(this.id_prefix);
        if (id != null) {
            sb.append(id).append(ID_SEPARATOR);
        }
        this.id_prefix = sb.toString();
    }

    private void parseLabel(Element itemsElement, HeaderItemsConfigElement result) {
        String label = itemsElement.attributeValue(ATTR_LABEL);
        result.setLabel(label);
    }

    private void parseCondition(Element itemsElement, HeaderItemsConfigElement result) {
        String condition;
        this.group_condition = condition = itemsElement.attributeValue(ATTR_CONDITION);
        result.setCondition(condition);
    }

    private void parsePermission(Element itemsElement, HeaderItemsConfigElement result) {
        String permission;
        this.group_permission = permission = itemsElement.attributeValue(ATTR_PERMISSION);
        result.setPermission(permission);
    }

    private String generateUniqueItemId(String id) {
        if (id == null) {
            return null;
        }
        return this.id_prefix.concat(id);
    }
}

