/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator;

import java.util.HashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.Evaluator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;

public abstract class BaseEvaluator
implements Evaluator {
    private static final String PORTLET_HOST = "portletHost";
    protected HashMap<String, String> args = null;
    protected JSONObject metadata = null;
    protected boolean negateOutput = false;

    public void setNegateOutput(boolean negateOutput) {
        this.negateOutput = negateOutput;
    }

    public final boolean evaluate(Object record) {
        return this.evaluate(record, null, null);
    }

    public final boolean evaluate(Object record, Object metadata) {
        return this.evaluate(record, metadata, null);
    }

    public final boolean evaluate(Object record, Object metadata, HashMap<String, String> args) {
        JSONObject jsonObject;
        block9: {
            this.args = args;
            try {
                if (record instanceof JSONObject) {
                    jsonObject = (JSONObject)record;
                } else if (record instanceof String) {
                    jsonObject = (JSONObject)JSONValue.parseWithException((String)((String)record));
                } else {
                    throw new IllegalArgumentException("Expecting either JSONObject or JSON String for 'record'");
                }
                if (metadata instanceof JSONObject) {
                    this.metadata = (JSONObject)metadata;
                    break block9;
                }
                if (metadata instanceof String) {
                    this.metadata = (JSONObject)JSONValue.parseWithException((String)((String)metadata));
                    break block9;
                }
                throw new IllegalArgumentException("Expecting either JSONObject or JSON String for 'metadata'");
            }
            catch (ParseException perr) {
                throw new AlfrescoRuntimeException("Failed to parse JSON string: " + perr.getMessage());
            }
            catch (Exception err) {
                throw new AlfrescoRuntimeException("Failed to run UI evaluator: " + err.getMessage());
            }
        }
        return this.negateOutput ^ this.evaluate(jsonObject);
    }

    public abstract boolean evaluate(JSONObject var1);

    public final HashMap<String, String> getArgs() {
        return this.args;
    }

    public final String getArg(String name) {
        if (this.args != null && this.args.containsKey(name)) {
            return (String)this.args.get(name);
        }
        return null;
    }

    public final JSONObject getMetadata() {
        return this.metadata;
    }

    public final String getHeader(String name) {
        String header = null;
        if (name != null) {
            RequestContext rc = ThreadLocalRequestContext.getRequestContext();
            header = rc.getHeader(name);
        }
        return header;
    }

    public final boolean getIsPortlet() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        return rc.getAttribute(PORTLET_HOST) != null;
    }

    public final String getNodeType(JSONObject jsonObject) {
        String type = null;
        try {
            JSONObject node = (JSONObject)jsonObject.get((Object)"node");
            if (node != null) {
                type = (String)node.get((Object)"type");
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst running UI evaluator: " + err.getMessage());
        }
        return type;
    }

    public final String getNodeMimetype(JSONObject jsonObject) {
        String mimetype = null;
        try {
            JSONObject node = (JSONObject)jsonObject.get((Object)"node");
            if (node != null) {
                mimetype = (String)node.get((Object)"mimetype");
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst running UI evaluator: " + err.getMessage());
        }
        return mimetype;
    }

    public final JSONArray getNodeAspects(JSONObject jsonObject) {
        JSONArray aspects = null;
        try {
            JSONObject node = (JSONObject)jsonObject.get((Object)"node");
            if (node != null) {
                aspects = (JSONArray)node.get((Object)"aspects");
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst running UI evaluator: " + err.getMessage());
        }
        return aspects;
    }

    public final Object getProperty(JSONObject jsonObject, String propertyName) {
        Object property = null;
        try {
            JSONObject properties;
            JSONObject node = (JSONObject)jsonObject.get((Object)"node");
            if (node != null && (properties = (JSONObject)node.get((Object)"properties")) != null) {
                property = properties.get((Object)propertyName);
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst running UI evaluator: " + err.getMessage());
        }
        return property;
    }

    public final String getUserId() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        String userId = rc.getUserId();
        if (userId == null || AuthenticationUtil.isGuest((String)userId)) {
            throw new AlfrescoRuntimeException("User ID must exist and cannot be guest.");
        }
        return userId;
    }

    public final String getSiteId(JSONObject jsonObject) {
        String siteId = null;
        try {
            JSONObject site;
            JSONObject location = (JSONObject)jsonObject.get((Object)"location");
            if (location != null && (site = (JSONObject)location.get((Object)"site")) != null) {
                siteId = (String)site.get((Object)"name");
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst querying siteId from location: " + err.getMessage());
        }
        return siteId;
    }

    public final String getSitePreset(JSONObject jsonObject) {
        String sitePreset = null;
        try {
            JSONObject site;
            JSONObject location = (JSONObject)jsonObject.get((Object)"location");
            if (location != null && (site = (JSONObject)location.get((Object)"site")) != null) {
                sitePreset = (String)site.get((Object)"preset");
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst querying site preset from location: " + err.getMessage());
        }
        return sitePreset;
    }

    public final String getContainerType(JSONObject jsonObject) {
        String containerType = null;
        try {
            JSONObject container;
            JSONObject location = (JSONObject)jsonObject.get((Object)"location");
            if (location != null && (container = (JSONObject)location.get((Object)"container")) != null) {
                containerType = (String)container.get((Object)"type");
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst querying container type from location: " + err.getMessage());
        }
        return containerType;
    }

    public final boolean getIsLocked(JSONObject jsonObject) {
        boolean isLocked = false;
        JSONObject node = (JSONObject)jsonObject.get((Object)"node");
        if (node != null) {
            isLocked = (Boolean)node.get((Object)"isLocked");
        }
        return isLocked;
    }

    public final boolean getIsWorkingCopy(JSONObject jsonObject) {
        boolean isWorkingCopy = false;
        JSONObject workingCopy = (JSONObject)jsonObject.get((Object)"workingCopy");
        if (workingCopy != null) {
            isWorkingCopy = (Boolean)workingCopy.get((Object)"isWorkingCopy");
        }
        return isWorkingCopy;
    }

    public final boolean getMatchesCurrentUser(JSONObject jsonObject, String propertyName) {
        try {
            JSONObject user = (JSONObject)this.getProperty(jsonObject, propertyName);
            if (user != null && user.get((Object)"userName").toString().equalsIgnoreCase(this.getUserId())) {
                return true;
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("Exception whilst matching current user: " + err.getMessage());
        }
        return false;
    }

    public final Object getJSONValue(JSONObject jsonObject, String accessor) {
        String[] keys = accessor.split("\\.");
        Object record = jsonObject;
        for (String key : keys) {
            if (record instanceof JSONObject) {
                record = record.get((Object)key);
                continue;
            }
            if (record instanceof JSONArray) {
                record = ((JSONArray)record).get(Integer.parseInt(key));
                continue;
            }
            return null;
        }
        return record;
    }

    public final boolean getHasContent(JSONObject jsonObject) {
        JSONObject node = (JSONObject)jsonObject.get((Object)"node");
        if (node != null) {
            return node.get((Object)"contentURL") != null;
        }
        return false;
    }
}

