/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import jakarta.servlet.ServletContextEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiTemplate;

public class ContextLoaderListener
extends org.springframework.web.context.ContextLoaderListener {
    private static final String PROPERTY_ENABLE_STARTUP = "java:comp/env/properties/startup.enable";
    protected static final Log log = LogFactory.getLog(ContextLoaderListener.class);
    private boolean enableStartup;

    public ContextLoaderListener() {
        try {
            this.enableStartup = (Boolean)new JndiTemplate().lookup(PROPERTY_ENABLE_STARTUP, Boolean.class);
        }
        catch (Exception e) {
            this.enableStartup = true;
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (this.enableStartup) {
            super.contextInitialized(event);
        } else {
            log.warn((Object)"The java:comp/env/properties/startup.enable environment entry is false. Please configure the environment entries for this application and then restart the server.");
        }
    }
}

