/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.StringTokenizer;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;

public class DownloadContentServlet
extends HttpServlet {
    private static final long serialVersionUID = -576405943603122206L;
    private static Log logger = LogFactory.getLog(DownloadContentServlet.class);
    private static final String URL_ATTACH = "a";
    private static final String URL_ATTACH_LONG = "attach";
    private static final String URL_DIRECT = "d";
    private static final String URL_DIRECT_LONG = "direct";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean isDirect;
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Authenticating (GET) request to URL: " + req.getRequestURI() + (String)(queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        String requestURI = req.getRequestURI();
        requestURI = requestURI.substring(req.getContextPath().length());
        StringTokenizer t = new StringTokenizer(requestURI, "/");
        int tokenCount = t.countTokens();
        t.nextToken();
        if (tokenCount < 6) {
            throw new IllegalArgumentException("Download URL did not contain all required args: " + requestURI);
        }
        String attachToken = t.nextToken();
        boolean isAttachment = URL_ATTACH.equalsIgnoreCase(attachToken) || URL_ATTACH_LONG.equalsIgnoreCase(attachToken);
        boolean bl = isDirect = URL_DIRECT.equalsIgnoreCase(attachToken) || URL_DIRECT_LONG.equalsIgnoreCase(attachToken);
        if (!isAttachment && !isDirect) {
            throw new IllegalArgumentException("Attachment mode is not properly specified: " + requestURI);
        }
        StoreRef storeRef = new StoreRef(URLDecoder.decode((String)t.nextToken()), URLDecoder.decode((String)t.nextToken()));
        boolean isWorkspaceStoreType = storeRef.getProtocol().equalsIgnoreCase("workspace");
        boolean isSpacesStoreStoreId = storeRef.getIdentifier().equalsIgnoreCase("SpacesStore");
        if (!isWorkspaceStoreType || !isSpacesStoreStoreId) {
            throw new IllegalArgumentException("Servlet accepts only nodes from workspace://SpaceStore/ storeRef: " + requestURI);
        }
        String nodeId = URLDecoder.decode((String)t.nextToken());
        String redirectUrl = String.format("%s/api/-default-/public/alfresco/versions/1/nodes/%s/content?attachment=%b", req.getContextPath(), nodeId, isAttachment);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request redirected to URL: " + redirectUrl));
        }
        res.sendRedirect(redirectUrl);
    }
}

