/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FPSEResponseElement {
    protected boolean isSingleValue;
    protected Map<String, FPSEResponseElement> subElements;
    protected ArrayList<FPSEResponseElement> anonymousLists;
    protected ArrayList<String> multiValues;
    protected String value;

    public FPSEResponseElement(String val) {
        this.isSingleValue = true;
        this.value = val;
    }

    public FPSEResponseElement() {
        this.isSingleValue = false;
        this.subElements = new HashMap<String, FPSEResponseElement>();
    }

    public void addElement(String name, FPSEResponseElement element) {
        if (this.isSingleValue) {
            throw new IllegalStateException("can not add sub-elements to single valued element.");
        }
        this.subElements.put(name, element);
    }

    public String getValue() {
        if (!this.isSingleValue) {
            throw new IllegalStateException("can not get value of list.");
        }
        return this.value;
    }

    public FPSEResponseElement getSubElement(String name) {
        if (this.isSingleValue) {
            throw new IllegalStateException("can not get sub-element of single valued element.");
        }
        return this.subElements.get(name);
    }

    public void addAnonymousList(FPSEResponseElement anonymousListElement) {
        if (this.anonymousLists == null) {
            this.anonymousLists = new ArrayList();
        }
        this.anonymousLists.add(anonymousListElement);
    }

    public ArrayList<FPSEResponseElement> getAnonymousLists() {
        return this.anonymousLists;
    }

    public void addListItem(String item) {
        if (this.multiValues == null) {
            this.multiValues = new ArrayList();
        }
        this.multiValues.add(item);
    }

    public List<String> getMultiValues() {
        return this.multiValues;
    }
}

