/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.io.IOException;
import java.io.InputStream;
import org.alfresco.officeservices.testclient.ServiceCommunicationException;
import org.alfresco.officeservices.testclient.ServiceResponseException;
import org.alfresco.officeservices.testclient.fpse.FPSEResponseElement;
import org.alfresco.officeservices.testclient.fpse.PushbackLineReader;

public class FPSEResponse {
    protected FPSEResponseElement topElement = new FPSEResponseElement();

    public FPSEResponse(InputStream in) throws ServiceCommunicationException, ServiceResponseException {
        try {
            PushbackLineReader plr = new PushbackLineReader(in);
            this.readMessage(plr);
        }
        catch (IOException ioe) {
            throw new ServiceCommunicationException(ioe);
        }
    }

    public FPSEResponseElement getTopElement() {
        return this.topElement;
    }

    protected void readMessage(PushbackLineReader plr) throws IOException, ServiceResponseException {
        if (!plr.readLine().equals("<html><head><title>vermeer RPC packet</title></head>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
        if (!plr.readLine().equals("<body>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
        this.readTopElement(plr);
        if (!plr.readLine().equals("</body>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
        if (!plr.readLine().equals("</html>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
    }

    protected void readTopElement(PushbackLineReader plr) throws IOException, ServiceResponseException {
        String line;
        while (true) {
            if ((line = plr.readLine()).equals("</body>")) break;
            if (!line.startsWith("<p>")) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            int sepPos = (line = line.substring(3)).indexOf(61);
            if (sepPos == -1) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            String name = line.substring(0, sepPos);
            String value = line.substring(sepPos + 1, line.length());
            String nextLine = plr.readLine();
            plr.pushBack(nextLine);
            if (nextLine.equals("<ul>")) {
                if (value.length() != 0) {
                    throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
                }
                FPSEResponseElement subElement = new FPSEResponseElement();
                if (name.equals("meta_info")) {
                    this.readMetaInfoElement(subElement, plr);
                } else if (name.equals("failedUrls")) {
                    this.readSubList(subElement, plr);
                } else {
                    this.readSubElement(subElement, plr);
                }
                this.topElement.addElement(name, subElement);
                continue;
            }
            this.topElement.addElement(name, new FPSEResponseElement(value));
        }
        plr.pushBack(line);
    }

    protected void readSubElement(FPSEResponseElement subElement, PushbackLineReader plr) throws IOException, ServiceResponseException {
        String line;
        if (!plr.readLine().equals("<ul>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
        while (!(line = plr.readLine()).equals("</ul>")) {
            if (line.equals("<ul>")) {
                plr.pushBack(line);
                FPSEResponseElement anonymousListElement = new FPSEResponseElement();
                this.readSubElement(anonymousListElement, plr);
                subElement.addAnonymousList(anonymousListElement);
                continue;
            }
            if (!line.startsWith("<li>")) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            int sepPos = (line = line.substring(4)).indexOf(61);
            if (sepPos == -1) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            String name = line.substring(0, sepPos);
            if (sepPos == line.length() - 1) {
                FPSEResponseElement subSubElement = new FPSEResponseElement();
                if (name.equals("meta_info")) {
                    this.readMetaInfoElement(subSubElement, plr);
                } else {
                    this.readSubElement(subSubElement, plr);
                }
                subElement.addElement(name, subSubElement);
                continue;
            }
            String value = line.substring(sepPos + 1, line.length());
            subElement.addElement(name, new FPSEResponseElement(value));
        }
    }

    protected void readMetaInfoElement(FPSEResponseElement subElement, PushbackLineReader plr) throws IOException, ServiceResponseException {
        String line1;
        if (!plr.readLine().equals("<ul>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
        while (!(line1 = plr.readLine()).equals("</ul>")) {
            if (!line1.startsWith("<li>")) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            String line2 = plr.readLine();
            if (line2.equals("</ul>")) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            if (!line2.startsWith("<li>")) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            subElement.addElement(line1.substring(4), new FPSEResponseElement(line2.substring(4)));
        }
    }

    protected void readSubList(FPSEResponseElement subElement, PushbackLineReader plr) throws IOException, ServiceResponseException {
        String line;
        if (!plr.readLine().equals("<ul>")) {
            throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
        }
        while (!(line = plr.readLine()).equals("</ul>")) {
            if (!line.startsWith("<li>")) {
                throw new ServiceResponseException("Invalid FPSE Message Syntax in line " + plr.getLineNumber());
            }
            line = line.substring(4);
            subElement.addListItem(line);
        }
    }
}

