/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class RestApiClient {
    private static final String REST_API_URI = "/alfresco/api/-default-/public/alfresco/versions/1/";
    private static final String NODES_CHILDREN_URI = "/alfresco/api/-default-/public/alfresco/versions/1/nodes/-my-/children";
    private RestTemplate restTemplate;
    private String host;

    public RestApiClient(String host) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper());
        this.restTemplate = new RestTemplate();
        this.restTemplate.getMessageConverters().add(converter);
        this.host = host;
    }

    public String createFileFromExisting(String username, String password, String path) {
        String fileNameExtension = StringUtils.getFilenameExtension((String)path);
        String fileNameCreated = String.valueOf(UUID.randomUUID()) + "." + fileNameExtension;
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"filedata", (Object)new ClassPathResource(path));
        map.add((Object)"name", (Object)fileNameCreated);
        HttpHeaders headers = this.createHeadersWithBasicAuth(username, password);
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        this.restTemplate.exchange(this.getUrl(NODES_CHILDREN_URI), HttpMethod.POST, requestEntity, String.class, new Object[0]);
        return fileNameCreated;
    }

    private HttpHeaders createHeadersWithBasicAuth(final String username, final String password) {
        return new HttpHeaders(){
            {
                String auth = username + ":" + password;
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes());
                String authHeader = "Basic " + new String(encodedAuth);
                this.set("Authorization", authHeader);
            }
        };
    }

    private String getUrl(String path) {
        return this.host + path;
    }
}

