/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient;

/**
 * Exception thrown whenever the service response is invalid.
 */
public class ServiceResponseException extends Exception
{

    /** the serial version ID */
    private static final long serialVersionUID = -6962256606344930025L;

    public ServiceResponseException()
    {
        super();
    }

    public ServiceResponseException(String message)
    {
        super(message);
    }

    public ServiceResponseException(Throwable cause)
    {
        super(cause);
    }

    public ServiceResponseException(String message, Throwable cause)
    {
        super(message, cause);
    }

}
