/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package demo;

import java.net.URI;
import java.util.ArrayList;

import org.alfresco.officeservices.testclient.AoservicesClient;
import org.alfresco.officeservices.testclient.AoservicesClient.FPSEGetDocsMetaInfo;
import org.alfresco.officeservices.testclient.fpse.FPSEResponseElement;
import org.junit.Test;

public class DemoServiceClientIT
{

    public static final String USERNAME = "admin";

    public static final String PASSWORD = "admin";

    public static final String TESTURI = "http://127.0.0.1:8080/alfresco/aos";
    
    AoservicesClient servicesClient = new AoservicesClient(USERNAME,PASSWORD);
    
    @Test
    public void testServiceClient() throws Exception
    {
        URI target = new URI(TESTURI);
        // _vti_inf.html
        System.out.println("Testing service information file...");
        AoservicesClient.VTI_INF_VERSION viv;
        viv = servicesClient.getVtiInformation(target);
        System.out.println("Service information file is of version "+viv);
        // FPSE version
        System.out.println("Testing FPSE version...");
        AoservicesClient.FPSEVersion fpseVersion = servicesClient.getFPSEVersion(target);
        System.out.println("FPSE version major="+fpseVersion.major+" minor="+fpseVersion.minor+" phase="+fpseVersion.phase+" incr="+fpseVersion.increase);
        // url to web url
        System.out.println("Testing FPSE url to web url...");
        AoservicesClient.FPSEUrlToWebUrl fpseUrlToWebUrl = servicesClient.getFPSEUrlToWebUrl(target);
        System.out.println("FPSE url to web url webUrl="+fpseUrlToWebUrl.webUrl+" fileUrl="+fpseUrlToWebUrl.fileUrl);
        // open service
        System.out.println("Testing FPSE open service...");
        FPSEResponseElement openServiceElement = servicesClient.getFPSEOpenService(fpseUrlToWebUrl.fpseEndpoint);
        System.out.println("FPSE open service vti_username="+openServiceElement.getSubElement("vti_username").getValue());
        // test status of sub directories
        if(fpseUrlToWebUrl.fileUrl.length()>0)
        {
            System.out.println("Testing FPSE getDocsMetaInfo for fileUrl...");
            ArrayList<String> targets = new ArrayList<String>(1);
            targets.add(fpseUrlToWebUrl.fileUrl);
            FPSEGetDocsMetaInfo docsMetaInfo = servicesClient.getFPSEGetDocsMetaInfo(fpseUrlToWebUrl.fpseEndpoint,targets);
            FPSEResponseElement metaInfo = docsMetaInfo.urldirs.get(fpseUrlToWebUrl.fileUrl);
            if(metaInfo == null)
            {
                System.out.println("ERROR: no meta_info for fileUrl");
            }
            else
            {
                System.out.println("FPSE getDocsMetaInfo returned");
            }
        }
        // test file dialog web form existence
        System.out.println("Testing Web Form existance...");
        boolean webFormExists = servicesClient.testWebFormExistence(fpseUrlToWebUrl.fpseEndpoint,fpseUrlToWebUrl.fileUrl,AoservicesClient.DialogType.FileOpen);
        System.out.println("Web form existance: "+webFormExists);
        // get file dialog web form
        System.out.println("Testing Web Form...");
        boolean webFormDelivered = servicesClient.getWebForm(fpseUrlToWebUrl.fpseEndpoint,fpseUrlToWebUrl.fileUrl,AoservicesClient.DialogType.FileOpen,null);
        System.out.println("Web form delivered: "+webFormDelivered);
    }

}
