/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.testclient.fpse;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.alfresco.officeservices.testclient.fpse.FPSERequestEntity;
import org.alfresco.officeservices.testclient.fpse.FPSERequestParameter;

public class FPSERequest {
    public static final String FPSE_CHARSET = "UTF-8";
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String NAME_VALUE_SEPARATOR = "=";
    protected URI serviceEndpoint;
    protected String methodName;
    protected String methodVersion;
    protected ArrayList<FPSERequestParameter> methodParameters = new ArrayList();

    public FPSERequest(URI endpoint, String name, String version) {
        this.serviceEndpoint = endpoint;
        this.methodName = name;
        this.methodVersion = version;
    }

    public void addParameter(String name, String value) {
        this.methodParameters.add(new FPSERequestParameter(name, value));
    }

    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public FPSERequestEntity getRequestEntity() {
        try {
            StringBuilder parameterData = new StringBuilder();
            parameterData.append(URLEncoder.encode("method", FPSE_CHARSET));
            parameterData.append(NAME_VALUE_SEPARATOR);
            parameterData.append(URLEncoder.encode(this.methodName + ":" + this.methodVersion, FPSE_CHARSET));
            for (FPSERequestParameter param : this.methodParameters) {
                String encodedName = URLEncoder.encode(param.getName(), FPSE_CHARSET);
                String value = param.getValue();
                String encodedValue = value != null ? URLEncoder.encode(value, FPSE_CHARSET) : "";
                parameterData.append(PARAMETER_SEPARATOR);
                parameterData.append(encodedName);
                parameterData.append(NAME_VALUE_SEPARATOR);
                parameterData.append(encodedValue);
            }
            byte[] parameterBytes = parameterData.toString().getBytes(FPSE_CHARSET);
            return new FPSERequestEntity(parameterBytes);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Platform does not support UTF-8 encoding");
        }
    }
}

