/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient;

/**
 * Exception thrown whenever an error occurs in the communication with the server.
 */
public class ServiceCommunicationException extends Exception
{

    /** the serial version ID */
    private static final long serialVersionUID = 2105683854530449363L;

    public ServiceCommunicationException()
    {
        super();
    }

    public ServiceCommunicationException(String message)
    {
        super(message);
    }

    public ServiceCommunicationException(Throwable cause)
    {
        super(cause);
    }

    public ServiceCommunicationException(String message, Throwable cause)
    {
        super(message, cause);
    }

}
