/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.net.URI;
import org.alfresco.officeservices.testclient.RestApiClient;
import org.alfresco.officeservices.testclient.office.Office2003WindowsXPClient;
import org.alfresco.officeservices.testclient.office.Office2007WindowsXPClient;
import org.alfresco.officeservices.testclient.office.Office2010Windows7Client;
import org.alfresco.officeservices.testclient.office.OfficeClientMessageReceiver;
import org.alfresco.officeservices.testclient.office.OfficeFileHandle;
import org.junit.BeforeClass;
import org.junit.Test;

public class DemoOfficeClientsIT
implements OfficeClientMessageReceiver {
    private static String USERNAME = "admin";
    private static String PASSWORD = "admin";
    private static String BASE_HOST = "http://localhost:8080";
    private static String BASE_URI = BASE_HOST + "/alfresco/aos";
    private static String DOCUMENT_NAME;

    @Override
    public void message(String msg) {
        System.out.println(msg);
    }

    @BeforeClass
    public static void createTestData() {
        RestApiClient restApiClient = new RestApiClient(BASE_HOST);
        DOCUMENT_NAME = restApiClient.createFileFromExisting(USERNAME, PASSWORD, "files/file.doc");
    }

    @Test
    public void testRunOffice2003OnWindowsXP() throws Exception {
        Office2003WindowsXPClient officeClient = new Office2003WindowsXPClient(USERNAME, PASSWORD);
        officeClient.setMessageReceiver(this);
        officeClient.fileOpenDialog(new URI(BASE_URI + "/"));
        OfficeFileHandle ofh = officeClient.openFile(new URI(BASE_URI + "/" + DOCUMENT_NAME));
        officeClient.refreshLock(ofh);
        officeClient.checkoutFile(ofh);
        officeClient.checkinFile(ofh, "comment", false);
        officeClient.closeFile(ofh);
    }

    @Test
    public void testRunOffice2007OnWindowsXP() throws Exception {
        Office2007WindowsXPClient officeClient = new Office2007WindowsXPClient(USERNAME, PASSWORD);
        officeClient.setMessageReceiver(this);
        officeClient.fileOpenDialog(new URI(BASE_URI + "/"));
        OfficeFileHandle ofh = officeClient.openFile(new URI(BASE_URI + "/" + DOCUMENT_NAME));
        officeClient.refreshLock(ofh);
        officeClient.checkoutFile(ofh);
        officeClient.checkinFile(ofh, "comment", false);
    }

    @Test
    public void testRunOffice2010OnWindows7() throws Exception {
        Office2010Windows7Client officeClient = new Office2010Windows7Client(USERNAME, PASSWORD);
        officeClient.setMessageReceiver(this);
        officeClient.fileOpenDialog(new URI(BASE_URI + "/"));
        OfficeFileHandle ofh = officeClient.openFile(new URI(BASE_URI + "/" + DOCUMENT_NAME));
        officeClient.refreshLock(ofh);
        officeClient.checkoutFile(ofh);
        officeClient.checkinFile(ofh, "comment", false);
    }
}

