/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.officeservices.testclient;

import java.net.URI;

import org.apache.http.annotation.Contract;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * HTTP PROPFIND method.
 *
 * @since 4.0
 */
@Contract(threading = org.apache.http.annotation.ThreadingBehavior.UNSAFE)
public class HttpLock extends HttpRequestBase
{

    public final static String METHOD_NAME = "LOCK";

    public HttpLock()
    {
        super();
    }

    public HttpLock(final URI uri)
    {
        super();
        setURI(uri);
    }

    /**
     * @throws IllegalArgumentException
     *             if the uri is invalid.
     */
    public HttpLock(final String uri)
    {
        super();
        setURI(URI.create(uri));
    }

    @Override
    public String getMethod()
    {
        return METHOD_NAME;
    }

}
