/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MSPowerPoint2007SanityTests
extends AOSTest {
    private UserModel testUser;
    private FileModel fileModel;
    private String updatedContent = "updatedContent";
    private FolderModel folderModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testSite = this.dataSite.createPublicRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.aosProtocol.authenticateUser(this.testUser);
        this.folderModel = FolderModel.getRandomFolderModel();
    }

    @BeforeMethod(alwaysRun=true)
    public void createFileModel() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT2007), FileType.MSPOWERPOINT2007, RandomData.getRandomName((String)"fileContent"));
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify content of MSPOWERPOINT2007 document after saving it and no content is added")
    @Test(groups={"protocols", "aos", "sanity"})
    public void savePowerPoint2007DocumentWithoutAnyChanges() throws Exception {
        String newContent = "";
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(newContent).then()).assertThat().contentIs(this.fileModel.getContent());
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin user renames MSPOWERPOINT2007 file with AOS Protocol")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToRenamePowerPoint2007File() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).rename(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT2007)).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin user deletes MSPOWERPOINT2007 file with AOS Protocol")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToDeletePowerPoint2007File() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).delete().and()).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin can update existing MSPOWERPOINT2007 document")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updateExistingPowerPoint2007DocumentWithAdmin() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin can update MSPOWERPOINT2007 document from Document Library")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updatePowerPoint2007FileFromDocumentLibray() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.testSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin can create MSPOWERPOINT2007 document in folder hierarchy")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCreatePowerPoint2007FileInFolderHierarchy() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).createFolder(this.folderModel).then()).createFile(this.fileModel).then()).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify site manager can update document")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updatePowerPoint2007DocumentWithManagerRole() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(siteManager, this.testSite, UserRole.SiteManager);
        this.aosProtocol.authenticateUser(siteManager);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.testSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }
}

