/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MSPowerPoint2003FullTests
extends AOSTest {
    private UserModel testUser;
    private FileModel fileModel;
    private SiteModel publicSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.publicSite = this.dataSite.createPublicRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.aosProtocol.authenticateUser(this.testUser);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT), FileType.MSPOWERPOINT, RandomData.getRandomName((String)"fileContent"));
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Add new page break to a Power Point 2003 document")
    @Test(groups={"protocols", "aos", "full"})
    public void addNewPageBreakToPowerPoint2003Document() throws Exception {
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).and()).addNewDocumentPage();
        this.aosProtocol.assertThat().newPageExistsAndContentIsValid();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Add a change to a document then check document version")
    @Test(groups={"protocols", "aos", "full"})
    public void checkPowerPoint2003DocumentVersionAfterUpdate() throws Exception {
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel);
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.fileModel)).assertContentVersionIs("1.1");
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)this.fileModel).update(RandomStringUtils.randomAlphanumeric((int)10));
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.fileModel)).assertContentVersionIs("1.2");
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can create document with name that contains spaces")
    @Test(groups={"protocols", "aos", "full"})
    public void adminCanCreatePowerPoint2003DocumentWithNameWithSpaces() throws Exception {
        this.fileModel = new FileModel("new file.ppt", FileType.MSPOWERPOINT, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).and()).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can create document with large amount of text as content")
    @Test(groups={"protocols", "aos", "full"})
    public void adminCanCreatePowerPoint2003DocumentWithLargeAmountOfText() throws Exception {
        this.fileModel = new FileModel("powerpoint1.ppt", FileType.MSPOWERPOINT, RandomStringUtils.randomAlphabetic((int)4500));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).and()).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is able to create several files and folders in the same location")
    @Test(groups={"protocols", "aos", "full"})
    public void userIsAbleToCreateSeveralFilesAndFolders() throws Exception {
        FileModel fileModel2 = new FileModel("powerpoint1.ppt", FileType.MSPOWERPOINT, RandomStringUtils.randomAlphabetic((int)4500));
        FileModel fileModel3 = new FileModel("powerpoint2.ppt", FileType.MSPOWERPOINT, RandomStringUtils.randomAlphabetic((int)4500));
        FolderModel newFolder1 = FolderModel.getRandomFolderModel();
        FolderModel newFolder2 = FolderModel.getRandomFolderModel();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).usingSite(this.publicSite).createFile(fileModel2).usingSite(this.publicSite).createFile(fileModel3).then()).usingSite(this.publicSite).createFolder(newFolder1).usingSite(this.publicSite).createFolder(newFolder2).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)newFolder2).assertThat().existsInRepo()).then()).usingResource((ContentModel)newFolder1).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)newFolder1).assertThat().existsInRepo()).then()).usingResource((ContentModel)fileModel3).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)fileModel3).assertThat().existsInRepo()).then()).usingResource((ContentModel)fileModel2).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)fileModel2).assertThat().existsInRepo()).then()).usingResource((ContentModel)this.fileModel).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.fileModel).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Checkout and cancel checkout of Power Point 2003 document")
    @Test(groups={"protocols", "aos", "full"})
    public void checkoutAndCancelCheckoutOfPowerPoint2003Document() throws Exception {
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).then()).checkOutDocument();
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)this.fileModel).update("New content added");
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.fileModel)).assertContentVersionIs("1.1");
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)this.fileModel).cancelCheckOutDocument().then()).update("New content added");
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.fileModel)).assertContentVersionIs("1.2");
    }
}

