/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MSExcel2007CoreTests
extends AOSTest {
    private UserModel testUser;
    private FileModel fileModel;
    private String updatedContent = "updatedContent";
    private String updatedContentWithSpecialSymbols = "`~@!#$%^&*()_-+=\\|]}[{'\";:/?.>,<";
    private SiteModel moderatedTestSite;
    private FolderModel folderModel;
    private SiteModel privateTestSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testSite = this.dataSite.createPublicRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.aosProtocol.authenticateUser(this.testUser);
        this.folderModel = FolderModel.getRandomFolderModel();
        this.moderatedTestSite = this.dataSite.createModeratedRandomSite();
        this.privateTestSite = this.dataSite.createPrivateRandomSite();
    }

    @BeforeMethod(alwaysRun=true)
    public void createFileModel() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007), FileType.MSEXCEL2007, RandomData.getRandomName((String)"fileContent"));
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can update document from moderated site")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2007DocumentFromModeratedSite() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.moderatedTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify content of file after deleting some content")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2007DocumentByDeletingSomeContent() throws Exception {
        this.updatedContent = this.updatedContent.substring(this.updatedContent.length() / 2);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).deleteContent(this.updatedContent).then()).assertThat().contentIs(this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Copy document to different location then update it and verify the new content")
    @Test(groups={"protocols", "aos", "core"})
    public void copyExcel2007DocumentToDifferentLocationThenUpdateIt() throws Exception {
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.moderatedTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo();
        this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().createFolder(this.folderModel);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().and()).update(this.updatedContent).then()).assertThat().contentIs(this.aosProtocol.getDefaultFileContent() + this.updatedContent);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can update document with special symbols")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2007DocumentWithSpecialSymbols() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.moderatedTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContentWithSpecialSymbols).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContentWithSpecialSymbols);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can update document from private site")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2007DocumentFromPrivateSite() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.privateTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Move document to different location then update it and verify the new content")
    @Test(groups={"protocols", "aos", "core"})
    public void moveExcel2007DocumentToDifferentLocationThenUpdateIt() throws Exception {
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.moderatedTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo();
        this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().createFolder(this.folderModel);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).and()).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can copy empty document to different location")
    @Test(groups={"protocols", "aos", "core"})
    public void copyEmptyExcel2007DocumentToDIfferentLocation() throws Exception {
        this.fileModel = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL2007);
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.moderatedTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo();
        this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().createFolder(this.folderModel);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can move empty document to different location")
    @Test(groups={"protocols", "aos", "core"})
    public void moveEmptyExcel2007DocumentToDIfferentLocation() throws Exception {
        this.fileModel = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL2007);
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.moderatedTestSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo();
        this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().createFolder(this.folderModel);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingSite(this.testSite).usingNetworkDrive().usingResource((ContentModel)this.fileModel).and()).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }
}

