/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import java.io.IOException;
import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MSExcel2003SanityTests
extends AOSTest {
    private UserModel testUser;
    private FileModel fileModel;
    private String updatedContent = "updatedContent";
    private FolderModel folderModel;
    @Value(value="${alfresco.server}")
    private String server;
    @Value(value="${alfresco.scheme}")
    private String scheme;
    @Value(value="${alfresco.port}")
    private String port;
    @Value(value="${admin.password:admin}")
    private String adminPassword;
    private CloseableHttpClient client;
    private String apiUrl;
    public static String ALFRESCO_API_PATH = "alfresco/service/api/";
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.logger.info((Object)("The Alfresco version from MSExcel2003SanityTests.dataPreparation is : " + Double.valueOf(StringUtils.substring((String)this.getAlfrescoVersion(this.scheme, this.server, this.port), (int)0, (int)3))));
        this.testSite = this.dataSite.createPublicRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.aosProtocol.authenticateUser(this.testUser);
        this.folderModel = FolderModel.getRandomFolderModel();
    }

    @BeforeMethod(alwaysRun=true)
    public void createFileModel() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL), FileType.MSEXCEL, RandomData.getRandomName((String)"fileContent"));
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify content of MSEXCEL2003 file after saving it and no content was added")
    @Test(groups={"protocols", "aos", "sanity"})
    public void saveExcel2003DocumentWithoutAnyChanges() throws Exception {
        String newContent = "";
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(newContent).then()).assertThat().contentIs(this.fileModel.getContent());
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin user renames MSEXCEL2003 file with AOS Protocol")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToRenameExcel2003File() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).rename(RandomData.getRandomFile((FileType)FileType.MSEXCEL)).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin user deletes MSEXCEL2003 file with AOS Protocol")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToDeleteExcel2003File() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).delete().and()).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin can update existing MSEXCEL2003 document")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updateExcel2003ExistingDocumentWithAdmin() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin can update MSEXCEL2003 document from Document Library")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updateExcel2003FileFromDocumentLibray() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.testSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin can create MSEXCEL2003 document in folder hierarchy")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCreateExcel2003FileInFolderHierarchy() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).createFolder(this.folderModel).then()).createFile(this.fileModel).then()).assertThat().existsInRepo();
    }

    public String getAlfrescoVersion(String scheme, String host, String port) {
        this.apiUrl = String.format("%s://%s:%s/%s", scheme, host, port, ALFRESCO_API_PATH);
        this.logger.info((Object)("Value of Scheme is :" + scheme + " \n Value host is :" + host + " \n Value port is :" + port));
        String url = this.apiUrl + "server";
        HttpGet get = new HttpGet(url);
        this.client = HttpClientBuilder.create().build();
        HttpResponse response = this.execute((HttpRequestBase)get);
        if (200 == response.getStatusLine().getStatusCode()) {
            try {
                String json_string = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONParser parser = new JSONParser();
                JSONObject obj = (JSONObject)parser.parse(json_string);
                JSONObject data = (JSONObject)obj.get((Object)"data");
                return (String)data.get((Object)"version");
            }
            catch (IOException | ParseException var8) {
                this.logger.error((Object)var8);
                return "";
            }
        }
        return "";
    }

    private HttpResponse execute(HttpRequestBase request) {
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)request);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Status Received:" + String.valueOf(response.getStatusLine())));
            }
            if (response.getStatusLine().getStatusCode() == 401) {
                throw new RuntimeException("Invalid user name or password");
            }
            return response;
        }
        catch (Exception var4) {
            this.logger.error((Object)response);
            this.logger.error((Object)var4);
            throw new RuntimeException("Error while executing request", var4);
        }
    }
}

