package org.alfresco.aos.web;

import org.alfresco.aos.AOSProperties;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.web.HtmlPage;
import org.alfresco.utility.web.annotation.PageObject;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Claudia Agache on 3/10/2017.
 */
@PageObject
public class AosLoginPage extends HtmlPage
{
    @Autowired
    AOSProperties aosProperties;
    
    public void authenticateSession(UserModel user)
    {
        browser.navigate().to(String.format("http://%s:%s@%s:%s%s", user.getUsername(), user.getPassword(), aosProperties.envProperty().getServer(), aosProperties.envProperty().getPort(), aosProperties.getAosPath()));
    }

    public void navigate()
    {
        browser.navigate().to(aosProperties.getAosLinuxNetwork().toString());
    }
    
    public void navigateTo(String URI)
    {
        browser.navigate().to(String.format("%s/%s", aosProperties.getAosLinuxNetwork().toString(), URI));
    }
}
