package org.alfresco.aos;

import org.alfresco.utility.TasProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@PropertySource("classpath:default.properties")
@PropertySource(value = "classpath:${environment}.properties", ignoreResourceNotFound = true)
public class AOSProperties
{
    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer()
    {
        return new PropertySourcesPlaceholderConfigurer();
    }
    
    @Autowired
    private TasProperties properties;

    public TasProperties envProperty()
    {
        return properties;
    }

    @Value("${aos.windowsNetwork}")
    private String aosWindowsNetwork;
    
    @Value("${aos.path}")
    private String aosPath;
   
    public String getAosPath()
    {
        return aosPath;
    }

    public String getAosWindowsNetwork()
    {
        // replace \ with \\ for Windows
        return aosWindowsNetwork.replace("\\", "\\\\");
    }

    public void setAosWindowsNetwork(String aosWindowsNetwork)
    {
        this.aosWindowsNetwork = aosWindowsNetwork;
    }
    
    @Value("${aos.linuxNetwork}")
    private String aosLinuxNetwork;

    public String getAosLinuxNetwork()
    {
        return aosLinuxNetwork;
    }

    public void setAosLinuxNetwork(String aosLinuxNetwork)
    {
        this.aosLinuxNetwork = aosLinuxNetwork;
    }	 
}
