/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos.dsl;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.exception.TestConfigurationException;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.springframework.beans.factory.annotation.Autowired;

public class AOSUtil {
    @Autowired
    DataContent dataContent;
    private AOSWrapper aosWrapper;

    public AOSUtil(AOSWrapper aosWrapper) {
        this.aosWrapper = aosWrapper;
    }

    public Document getCMISDocument() {
        Document document = this.dataContent.getCMISDocument(this.aosWrapper.getLastResource());
        return document;
    }

    public List<SecondaryType> getDocumentSecondaryTypes(Document document) {
        return document.getSecondaryTypes();
    }

    public boolean contentExistsInAos(String pathToFile) throws TestConfigurationException {
        File newFile = Paths.get(pathToFile, new String[0]).toFile();
        return newFile.exists();
    }

    protected synchronized int getStatus() {
        return this.aosWrapper.status;
    }
}

