/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos.dsl;

import org.alfresco.aos.AOSProperties;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.network.NetworkDrive;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AOSNetworkDrive {
    @Autowired
    AOSProperties aosProperties;
    @Autowired
    private DataUser dataUser;
    static Logger LOG = LogFactory.getLogger();
    static boolean secretAdded = false;

    public NetworkDrive inOSEnvironment() throws TestConfigurationException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.winOS();
        }
        if (SystemUtils.IS_OS_LINUX) {
            return this.linuxOS();
        }
        if (SystemUtils.IS_OS_MAC) {
            return this.macOS();
        }
        throw new TestConfigurationException("NetworkDrive was not configure YET for this Operating System. AOS will be mapped and run only on Windows and LINUX operating System so far. Please change your agent to run on a Windows/Linux Test Environments. Current tests are being executed on OS: " + SystemUtils.OS_NAME);
    }

    private NetworkDrive winOS() {
        return new NetworkDrive(this.dataUser.getAdminUser(), this.aosProperties.getAosWindowsNetwork(), "Y:"){

            protected void umountCode() throws Exception {
                this.runCommand("start /WAIT net use %s /d /y", new Object[]{"*"});
            }

            protected void mountCode() throws Exception {
                LOG.info(String.format("Mounting Windows drive on server = '%s' on local volume = '%s'", this.getServerNetworkPath(), this.getLocalVolumePath()));
                this.runCommand("start /WAIT net use %s %s /user:%s %s /persistent:yes", new Object[]{this.getLocalVolumePath(), this.getServerNetworkPath(), this.getUserForNetworkAccess().getUsername(), this.getUserForNetworkAccess().getPassword()});
            }
        };
    }

    private NetworkDrive linuxOS() {
        return new NetworkDrive(this.dataUser.getAdminUser(), this.aosProperties.getAosLinuxNetwork(), "/mnt/alfrescoAos"){

            protected void umountCode() throws Exception {
                this.runCommand("sudo umount -t davfs -l %s", new Object[]{this.getLocalVolumePath()});
                Utility.waitToLoopTime((int)20, (String[])new String[]{"until AOS umount is complete!"});
                this.runCommand("sudo rm -rf %s", new Object[]{this.getLocalVolumePath()});
            }

            protected void mountCode() throws Exception {
                if (!secretAdded) {
                    LOG.info(String.format("Adding the Secret for DAVFS on server = '%s'", this.getServerNetworkPath()));
                    this.runCommand("echo '%s %s %s' | sudo tee /etc/davfs2/secrets", new Object[]{AOSNetworkDrive.this.aosProperties.getAosLinuxNetwork(), this.getUserForNetworkAccess().getUsername(), this.getUserForNetworkAccess().getPassword()});
                    secretAdded = true;
                }
                LOG.info(String.format("Mounting Linux drive using DAVFS on server = '%s' on local volume = '%s'", this.getServerNetworkPath(), this.getLocalVolumePath()));
                this.runCommand("sudo mkdir -p " + this.getLocalVolumePath(), new Object[0]);
                this.runCommand("sudo mount -t davfs %s %s -o rw -o uid=travis,gid=travis,file_mode=0777,dir_mode=0777", new Object[]{AOSNetworkDrive.this.aosProperties.getAosLinuxNetwork(), this.getLocalVolumePath()});
                this.runCommand(String.format("sudo chmod 777 -R %s", this.getLocalVolumePath()), new Object[0]);
                Utility.waitToLoopTime((int)20, (String[])new String[]{"until AOS mounting is complete!"});
            }
        };
    }

    private NetworkDrive macOS() {
        return new NetworkDrive(this.dataUser.getAdminUser(), this.aosProperties.getAosLinuxNetwork(), "/data/alfrescoAos"){

            protected void umountCode() throws Exception {
            }

            protected void mountCode() throws Exception {
            }
        };
    }
}

