/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MSExcel2003CoreTests
extends AOSTest {
    private UserModel testUser;
    private FileModel fileModel;
    private FolderModel folderModel;
    private String updatedContent = "updatedContent";
    private SiteModel moderatedSite;
    private SiteModel publicSite;
    private SiteModel privateSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.publicSite = this.dataSite.createPublicRandomSite();
        this.moderatedSite = this.dataSite.createModeratedRandomSite();
        this.privateSite = this.dataSite.createPrivateRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.folderModel = FolderModel.getRandomFolderModel();
        this.aosProtocol.authenticateUser(this.testUser);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL), FileType.MSEXCEL, RandomData.getRandomName((String)"fileContent"));
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Update Excel 2003 document from moderated site")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2003DocumentFromModeratedSite() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFile(this.fileModel).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Copy Excel 2003 document to another location then try to update its content")
    @Test(groups={"protocols", "aos", "core"})
    public void copyExcel2003DocumentThenUpdateItsContent() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).then()).copyTo((ContentModel)this.folderModel).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
        this.aosProtocol.usingNetworkDrive().usingResource((ContentModel)this.fileModel).assertThat().contentIs(this.fileModel.getContent());
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Move Excel 2003 document to another location then try to update its content")
    @Test(groups={"protocols", "aos", "core"})
    public void moveExcel2003DocumentThenUpdateItsContent() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).then()).moveTo((ContentModel)this.folderModel).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)this.fileModel).assertThat().fileDoesNotExistInAOS().and()).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify content of file after deleting some content")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2003DocumentByDeletingSomeContent() throws Exception {
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel);
        this.updatedContent = this.fileModel.getContent();
        this.updatedContent = this.updatedContent.substring(this.updatedContent.length() / 2);
        ((AOSWrapper)this.aosProtocol.usingResource((ContentModel)this.fileModel).deleteContent(this.updatedContent).then()).assertThat().contentIs(this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Update Excel 2003 document from private site")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2003DocumentFromPrivateSite() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.privateSite).createFile(this.fileModel).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Update Excel 2003 document using special symbols")
    @Test(groups={"protocols", "aos", "core"})
    public void updateExcel2003DocumentWithSpecialSymbols() throws Exception {
        String specialContent = "`~@!#$%^&*()_-+=\\|]}[{'\";:/?.>,<";
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFile(this.fileModel).and()).update(specialContent).then()).assertThat().contentIs(this.fileModel.getContent() + specialContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="User is able to create several files and folders in AOS network drive")
    @Test(groups={"protocols", "aos", "core"})
    public void createSeveralExcel2003FilesAndFoldersInAosNetworkDrive() throws Exception {
        FolderModel folder1 = FolderModel.getRandomFolderModel();
        FolderModel folder2 = FolderModel.getRandomFolderModel();
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        FileModel file2 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        FileModel file3 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFolder(folder1).usingSite(this.publicSite).createFolder(folder2).createFile(file3).usingSite(this.publicSite).createFile(file1).usingSite(this.publicSite).createFile(file2);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingNetworkDrive().usingResource((ContentModel)folder1).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)folder2).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file3).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file1).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file2).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Verify that user is able to copy/move Excel 2003 file with no content")
    @Test(groups={"protocols", "aos", "core"})
    public void copyMoveExcel2003DocumentThatHasNoContent() throws Exception {
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFolder(this.folderModel);
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL), FileType.MSEXCEL, "");
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFile(this.fileModel).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().fileExistsInAOS().assertThat().existsInRepo()).and()).assertThat().contentIs("").then()).usingResource((ContentModel)this.fileModel).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        FolderModel newFolder = FolderModel.getRandomFolderModel();
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFolder(newFolder);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFile(this.fileModel).then()).moveTo((ContentModel)newFolder).and()).assertThat().fileExistsInAOS().assertThat().existsInRepo()).and()).assertThat().contentIs("").then()).usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }
}

