package org.alfresco.aos.dsl;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;

import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.exception.TestConfigurationException;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.springframework.beans.factory.annotation.Autowired;

public class AOSUtil
{
    @Autowired
    DataContent dataContent;
    
    private AOSWrapper aosWrapper;

    public AOSUtil(AOSWrapper aosWrapper)
    {
        this.aosWrapper = aosWrapper;
    }
    
    public Document getCMISDocument()
    {
        Document document = dataContent.getCMISDocument(aosWrapper.getLastResource());

        return document;
    }

    public List<SecondaryType> getDocumentSecondaryTypes(Document document)
    {
        return document.getSecondaryTypes();
    }
    
    public boolean contentExistsInAos(String pathToFile) throws TestConfigurationException
    {
        File newFile = Paths.get(pathToFile).toFile();

        if (newFile.exists())
        {
            return true;
        }

        else
        {
            return false;
        }
    }

    protected synchronized int getStatus()
    {
        return aosWrapper.status;
    }
}