/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.module.aosmodule.dispatch;

import java.io.IOException;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;

import org.alfresco.officeservices.Types;

public class ServiceFilter implements Filter
{

    public void init(FilterConfig filterConfig) throws ServletException
    {
        // nothing to destroy here
    }

    public void destroy()
    {
        // nothing to destroy here
    }

    public String toString()
    {
        return "xosdav ServiceFilter";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
    {
        if (response instanceof HttpServletResponse)
        {
            appendResponseHeaders((HttpServletResponse) response);
        }
        chain.doFilter(request, response);
    }

    static void appendResponseHeaders(HttpServletResponse response)
    {
        response.addHeader("MicrosoftSharePointTeamServices", Types.WSS_VERSION_STRING);
    }

}