/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.workflow;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;

public class PrincipalInfo {
    protected String accountName;
    protected long id;
    protected String displayName;
    protected boolean resolved;
    protected String principalType;
    protected List<PrincipalInfo> moreMatches;
    public static final String PRINCIPALTYPE_NONE = "None";
    public static final String PRINCIPALTYPE_USER = "User";
    public static final String PRINCIPALTYPE_ALL = "All";
    public static final String PRINCIPALTYPE_SECURITYGROUP = "SecurityGroup";
    public static final String PRINCIPALTYPE_SHAREPOINTGROUP = "SharePointGroup";
    public static final String PRINCIPALTYPE_DISTRIBUTIONLIST = "DistributionList";

    public PrincipalInfo(String accountName, long id, String displayName, boolean resolved, String principalType) {
        this.accountName = accountName;
        this.id = id;
        this.displayName = displayName;
        this.resolved = resolved;
        this.principalType = principalType;
    }

    public void addMoreMatches(PrincipalInfo principalInfo) {
        if (this.moreMatches == null) {
            this.moreMatches = new ArrayList<PrincipalInfo>();
        }
        if (principalInfo != null) {
            this.moreMatches.add(principalInfo);
        }
    }

    public void write(PrintStream out) throws IOException {
        out.print("<PrincipalInfo>");
        out.print("<AccountName>");
        AbstractSoapService.writeEncoded(out, this.accountName);
        out.print("</AccountName>");
        out.print("<UserInfoID>");
        AbstractSoapService.writeEncoded(out, Long.toString(this.id));
        out.print("</UserInfoID>");
        if (this.displayName != null) {
            out.print("<DisplayName>");
            AbstractSoapService.writeEncoded(out, this.displayName);
            out.print("</DisplayName>");
        }
        out.print("<IsResolved>");
        AbstractSoapService.writeEncoded(out, this.resolved ? "true" : "false");
        out.print("</IsResolved>");
        if (this.moreMatches != null) {
            out.print("<MoreMatches>");
            for (PrincipalInfo match : this.moreMatches) {
                match.write(out);
            }
            out.print("</MoreMatches>");
        }
        out.print("<PrincipalType>");
        AbstractSoapService.writeEncoded(out, this.principalType);
        out.print("</PrincipalType>");
        out.print("</PrincipalInfo>");
    }
}

