/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.protocol.VermeerReturnValue;

public class VermeerReturnList
implements VermeerReturnValue {
    protected boolean topLevel = false;
    protected List<VermeerReturnListItem> items = new ArrayList<VermeerReturnListItem>();

    public VermeerReturnList(boolean isTopLevel) {
        this.topLevel = isTopLevel;
    }

    public VermeerReturnList() {
        this(false);
    }

    public void add(String name, VermeerReturnValue value) {
        this.items.add(new VermeerReturnListItem(name, value));
    }

    public int size() {
        return this.items.size();
    }

    public String getName(int i) {
        return this.items.get(i).getName();
    }

    public VermeerReturnValue getValue(int i) {
        return this.items.get(i).getValue();
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        if (!this.topLevel) {
            out.print("\n<ul>");
        }
        for (VermeerReturnListItem listItem : this.items) {
            if (this.topLevel) {
                out.print("\n<p>");
            } else {
                out.print("\n<li>");
            }
            out.print(listItem.getName());
            out.print("=");
            listItem.getValue().write(out);
        }
        if (!this.topLevel) {
            out.print("\n</ul>");
        }
    }

    @Override
    public String toTraceString() {
        return "####";
    }

    protected static class VermeerReturnListItem {
        protected String name;
        protected VermeerReturnValue value;

        public VermeerReturnListItem(String name, VermeerReturnValue value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public VermeerReturnValue getValue() {
            return this.value;
        }
    }
}

