/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.Date;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;

public class VermeerReturnDictionaryLibrary
implements VermeerReturnDictionary {
    protected String guid;
    protected String title;
    protected Date dateCreated;
    protected Date dateLastModified;
    protected boolean minorVersionsEnabled;

    public VermeerReturnDictionaryLibrary(String guid, String title, Date dateCreated, Date dateLastModified, boolean minorVersionsEnabled) {
        this.guid = guid;
        this.title = title;
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
        this.minorVersionsEnabled = minorVersionsEnabled;
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        out.print("\n<ul>");
        out.print("\n<li>vti_isexecutable");
        out.print("\n<li>BR|false");
        out.print("\n<li>vti_isbrowsable");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_isscriptable");
        out.print("\n<li>BR|false");
        out.print("\n<li>vti_hassubdirs");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_listbasetype");
        out.print("\n<li>IR|1");
        out.print("\n<li>vti_timecreated");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateCreated));
        out.print("\n<li>vti_listservertemplate");
        out.print("\n<li>IR|101");
        out.print("\n<li>vti_listname");
        out.print("\n<li>SR|" + VermeerResponse.encodeString(this.guid));
        out.print("\n<li>vti_listtitle");
        out.print("\n<li>SR|" + VermeerResponse.encodeString(this.title));
        out.print("\n<li>vti_dirlateststamp");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLastModified));
        out.print("\n<li>vti_timelastmodified");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLastModified));
        out.print("\n<li>vti_nexttolasttimemodified");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLastModified));
        out.print("\n<li>vti_listenableversioning");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_listenableminorversions");
        out.print("\n<li>BR|" + (this.minorVersionsEnabled ? "true" : "false"));
        out.print("\n<li>vti_candeleteversion");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_listrequirecheckout");
        out.print("\n<li>BR|false");
        out.print("\n<li>vti_level");
        out.print("\n<li>IR|1");
        out.print("\n<li>vti_listenablemoderation");
        out.print("\n<li>BR|false");
        out.print("\n<li>vti_foldersubfolderitemcount");
        out.print("\n<li>IR|0");
        out.print("\n<li>vti_folderitemcount");
        out.print("\n<li>IR|0");
        out.print("\n<li>vti_etag");
        out.print("\n<li>SW|" + VermeerResponse.encodeString("\"" + this.guid + ",0\""));
        if (this.guid.length() > 2 && this.guid.charAt(0) == '{' && this.guid.charAt(this.guid.length() - 1) == '}') {
            out.print("\n<li>vti_rtag");
            out.print("\n<li>SW|rt:" + VermeerResponse.encodeString(this.guid.substring(1, this.guid.length() - 1)) + "@00000000000");
        }
        out.print("\n</ul>");
    }

    @Override
    public String toTraceString() {
        StringBuffer sb = new StringBuffer();
        sb.append("vti_timecreated");
        sb.append(VermeerResponse.formatDate(this.dateCreated));
        sb.append(" vti_listname=");
        sb.append("&#123;" + VermeerResponse.encodeString(this.guid) + "&#125;");
        sb.append(" vti_listtitle=");
        sb.append(VermeerResponse.encodeString(this.title));
        sb.append(" vti_dirlateststamp=");
        sb.append(VermeerResponse.formatDate(this.dateLastModified));
        sb.append(" vti_timelastmodified=");
        sb.append(VermeerResponse.formatDate(this.dateLastModified));
        sb.append(" vti_nexttolasttimemodified=");
        sb.append(VermeerResponse.formatDate(this.dateLastModified));
        return sb.toString();
    }
}

