/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class HtmlEncoder {
    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&#39;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static void writeEncoded(ServletOutputStream out, String s, String charsetName) throws IOException {
        byte[] bytes;
        if (s == null) {
            return;
        }
        try {
            bytes = s.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException uee) {
            bytes = s.getBytes();
        }
        block9: for (int i = 0; i < bytes.length; ++i) {
            char c = (char)(0xFF & bytes[i]);
            switch (c) {
                case '&': {
                    out.print("&amp;");
                    continue block9;
                }
                case '\"': {
                    out.print("&quot;");
                    continue block9;
                }
                case '\'': {
                    out.print("&#39;");
                    continue block9;
                }
                case '>': {
                    out.print("&gt;");
                    continue block9;
                }
                case '<': {
                    out.print("&lt;");
                    continue block9;
                }
                default: {
                    out.print(c);
                }
            }
        }
    }

    public static void writeEncoded(Writer out, StringBuffer sb) throws IOException {
        if (sb == null) {
            return;
        }
        block7: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            switch (c) {
                case '&': {
                    out.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    out.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    out.write("&#39;");
                    continue block7;
                }
                case '>': {
                    out.write("&gt;");
                    continue block7;
                }
                case '<': {
                    out.write("&lt;");
                    continue block7;
                }
                default: {
                    out.write(c);
                }
            }
        }
    }

    public static void appendEncoded(StringBuffer payload, String value) {
        HtmlEncoder.appendEncoded(payload, value, false);
    }

    public static void appendEncoded(StringBuffer payload, String value, boolean canContainLinebreaks) {
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\r': {
                    if (canContainLinebreaks) {
                        payload.append("&#013;");
                        continue block9;
                    }
                    payload.append(" ");
                    continue block9;
                }
                case '\n': {
                    if (canContainLinebreaks) {
                        payload.append("&#010;");
                        continue block9;
                    }
                    payload.append(" ");
                    continue block9;
                }
                case '&': {
                    payload.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    payload.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    payload.append("&apos;");
                    continue block9;
                }
                case '<': {
                    payload.append("&lt;");
                    continue block9;
                }
                case '>': {
                    payload.append("&gt;");
                    continue block9;
                }
                default: {
                    payload.append(c);
                }
            }
        }
    }

    private HtmlEncoder() {
    }
}

