/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;

public class ListsGetListList {
    protected int serverTemplate = 100;
    protected String id;
    protected String title;
    protected String description;
    protected String featureId = "{00BFEA71-DE22-43B2-A848-C05709900100}";
    protected long itemCount = 0L;
    protected String rootFolder;
    protected String webFullUrl;
    protected String serverVersion = "15.0.0.4420";
    public static final String BASETYPE_LISTS = "0";
    public static final String BASETYPE_DOCLIBRARY = "1";
    public static final String FEATUREID_GENERIC = "{00BFEA71-DE22-43B2-A848-C05709900100}";
    public static final String FEATUREID_DOCUMENT_LIBRARY = "{00BFEA71-E717-4E80-AA17-D0C71B360101}";
    public static final String FEATUREID_SURVEY = "{00BFEA71-E717-4E80-AA17-D0C71B360102}";
    public static final String FEATUREID_LINKS = "{00BFEA71-2062-426C-90BF-714C59600103}";
    public static final String FEATUREID_ANNOUNCEMENTS = "{00BFEA71-D1CE-42DE-9C63-A44004CE0104}";
    public static final String FEATUREID_CONTACTS = "{00BFEA71-7E6D-4186-9BA8-C047AC750105}";
    public static final String FEATUREID_CALENDAR = "{00BFEA71-EC85-4903-972D-EBE475780106}";
    public static final String FEATUREID_TASKS = "{00BFEA71-A83E-497E-9BA0-7A5C597D0107}";
    public static final String FEATUREID_DISCUSSIONS = "{00BFEA71-6A49-43FA-B535-D15C05500108}";
    public static final String FEATUREID_PICTURE_LIBRARY = "{00BFEA71-6A49-43FA-B535-D15C05500109}";
    public static final String FEATUREID_DATA_SOURCES = "{00BFEA71-6A49-43FA-B535-D15C05500110}";
    public static final int SERVERTEMPLATE_GENERIC = 100;
    public static final int SERVERTEMPLATE_DOCUMENT_LIBRARY = 101;
    public static final int SERVERTEMPLATE_SURVEY = 102;
    public static final int SERVERTEMPLATE_LINKS = 103;
    public static final int SERVERTEMPLATE_ANNOUNCEMENTS = 104;
    public static final int SERVERTEMPLATE_CONTACTS = 105;
    public static final int SERVERTEMPLATE_CALENDAR = 106;
    public static final int SERVERTEMPLATE_TASKS = 107;
    public static final int SERVERTEMPLATE_DISCUSSIONS = 108;
    public static final int SERVERTEMPLATE_PICTURE_LIBRARY = 109;
    public static final int SERVERTEMPLATE_DATA_SOURCES = 110;
    private static final ServiceLogger logger = new ServiceLogger(ListsGetListList.class);

    public ListsGetListList(int serverTemplate, String id, String title, String description, String rootFolder, String webFullUrl) {
        this.serverTemplate = serverTemplate;
        this.id = id;
        this.title = title;
        this.description = description;
        this.rootFolder = rootFolder;
        this.webFullUrl = webFullUrl;
        switch (this.serverTemplate) {
            case 100: {
                this.featureId = FEATUREID_GENERIC;
                break;
            }
            case 101: {
                this.featureId = FEATUREID_DOCUMENT_LIBRARY;
                break;
            }
            case 102: {
                this.featureId = FEATUREID_SURVEY;
                break;
            }
            case 103: {
                this.featureId = FEATUREID_LINKS;
                break;
            }
            case 104: {
                this.featureId = FEATUREID_ANNOUNCEMENTS;
                break;
            }
            case 105: {
                this.featureId = FEATUREID_CONTACTS;
                break;
            }
            case 106: {
                this.featureId = FEATUREID_CALENDAR;
                break;
            }
            case 107: {
                this.featureId = FEATUREID_TASKS;
                break;
            }
            case 108: {
                this.featureId = FEATUREID_DISCUSSIONS;
                break;
            }
            case 109: {
                this.featureId = FEATUREID_PICTURE_LIBRARY;
                break;
            }
            case 110: {
                this.featureId = FEATUREID_DATA_SOURCES;
                break;
            }
            default: {
                this.featureId = FEATUREID_GENERIC;
            }
        }
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void setServerTemplate(int serverTemplate) {
        this.serverTemplate = serverTemplate;
    }

    public void setItemCount(long itemCount) {
        this.itemCount = itemCount;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void write(PrintStream out) throws IOException {
        out.print("<List");
        AbstractSoapService.writeXmlAttribute(out, "DocTemplateUrl", "", true);
        AbstractSoapService.writeXmlAttribute(out, "DefaultViewUrl", "", true);
        AbstractSoapService.writeXmlAttribute(out, "MobileDefaultViewUrl", "", true);
        AbstractSoapService.writeXmlAttribute(out, "ID", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "Title", this.title, true);
        AbstractSoapService.writeXmlAttribute(out, "Description", this.description, true);
        AbstractSoapService.writeXmlAttribute(out, "ImageUrl", "", true);
        AbstractSoapService.writeXmlAttribute(out, "Name", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "BaseType", this.serverTemplate == 101 || this.serverTemplate == 109 ? BASETYPE_DOCLIBRARY : BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "FeatureId", this.featureId, true);
        AbstractSoapService.writeXmlAttribute(out, "ServerTemplate", Integer.toString(this.serverTemplate), true);
        AbstractSoapService.writeXmlAttribute(out, "Created", "20000101 00:00:00", true);
        AbstractSoapService.writeXmlAttribute(out, "Modified", "20000101 00:00:00", true);
        AbstractSoapService.writeXmlAttribute(out, "LastDeleted", "20000101 00:00:00", true);
        AbstractSoapService.writeXmlAttribute(out, "Version", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "Direction", "none", true);
        AbstractSoapService.writeXmlAttribute(out, "ThumbnailSize", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "WebImageWidth", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "WebImageHeight", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "Flags", "4096", true);
        AbstractSoapService.writeXmlAttribute(out, "ItemCount", Long.toString(this.itemCount), true);
        AbstractSoapService.writeXmlAttribute(out, "AnonymousPermMask", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "RootFolder", this.rootFolder, true);
        AbstractSoapService.writeXmlAttribute(out, "ReadSecurity", BASETYPE_DOCLIBRARY, true);
        AbstractSoapService.writeXmlAttribute(out, "WriteSecurity", BASETYPE_DOCLIBRARY, true);
        AbstractSoapService.writeXmlAttribute(out, "Author", BASETYPE_DOCLIBRARY, true);
        AbstractSoapService.writeXmlAttribute(out, "EventSinkAssembly", "", true);
        AbstractSoapService.writeXmlAttribute(out, "EventSinkClass", "", true);
        AbstractSoapService.writeXmlAttribute(out, "EventSinkData", "", true);
        AbstractSoapService.writeXmlAttribute(out, "EmailInsertsFolder", "", true);
        AbstractSoapService.writeXmlAttribute(out, "EmailAlias", "", true);
        AbstractSoapService.writeXmlAttribute(out, "WebFullUrl", this.webFullUrl, true);
        AbstractSoapService.writeXmlAttribute(out, "WebId", "00000000-0000-0000-0000-000000000000", true);
        AbstractSoapService.writeXmlAttribute(out, "SendToLocation", "", true);
        AbstractSoapService.writeXmlAttribute(out, "ScopeId", "00000000-0000-0000-0000-000000000000", true);
        AbstractSoapService.writeXmlAttribute(out, "MajorVersionLimit", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "MajorWithMinorVersionsLimit", BASETYPE_LISTS, true);
        AbstractSoapService.writeXmlAttribute(out, "WorkFlowId", "00000000-0000-0000-0000-000000000000", true);
        AbstractSoapService.writeXmlAttribute(out, "HasUniqueScopes", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "AllowDeletion", "True", true);
        AbstractSoapService.writeXmlAttribute(out, "AllowMultiResponses", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "EnableAttachments", "True", true);
        AbstractSoapService.writeXmlAttribute(out, "EnableModeration", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "EnableVersioning", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "Hidden", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "MultipleDataList", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "Ordered", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "ShowUser", "True", true);
        AbstractSoapService.writeXmlAttribute(out, "EnableMinorVersion", "False", true);
        AbstractSoapService.writeXmlAttribute(out, "RequireCheckout", "False", true);
        out.print(">");
        this.writeFields(out);
        this.writeRegionalSettings(out);
        this.writeServerSettings(out);
        out.print("</List>");
    }

    protected void writeFields(PrintStream out) {
        out.print("<Fields>");
        switch (this.serverTemplate) {
            case 100: {
                this.includeTemplateFields(out, "generic");
                break;
            }
            case 101: {
                this.includeTemplateFields(out, "documentlibrary");
                break;
            }
            case 102: {
                this.includeTemplateFields(out, "survey");
                break;
            }
            case 103: {
                this.includeTemplateFields(out, "links");
                break;
            }
            case 104: {
                this.includeTemplateFields(out, "announcements");
                break;
            }
            case 105: {
                this.includeTemplateFields(out, "contacts");
                break;
            }
            case 106: {
                this.includeTemplateFields(out, "calendar");
                break;
            }
            case 107: {
                this.includeTemplateFields(out, "tasks");
                break;
            }
            case 108: {
                this.includeTemplateFields(out, "discussions");
                break;
            }
            case 109: {
                this.includeTemplateFields(out, "picturelibrary");
                break;
            }
            case 110: {
                this.includeTemplateFields(out, "datasources");
                break;
            }
            default: {
                this.includeTemplateFields(out, "generic");
            }
        }
        out.print("</Fields>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeTemplateFields(PrintStream out, String listTemplateName) {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/alfresco/officeservices/lists/templates/fields_" + listTemplateName + ".template");
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                out.print(line);
            }
        }
        catch (IOException e) {
            logger.error("Error loading template field definitions.", e);
        }
    }

    protected void writeRegionalSettings(PrintStream out) {
        out.print("<RegionalSettings>");
        out.print("<Language>1031</Language>");
        out.print("<Locale>1031</Locale>");
        out.print("<AdvanceHijri>0</AdvanceHijri>");
        out.print("<CalendarType>1</CalendarType>");
        out.print("<Time24>True</Time24>");
        out.print("<TimeZone>0</TimeZone>");
        out.print("<SortOrder>2070</SortOrder>");
        out.print("<Presence>True</Presence>");
        out.print("</RegionalSettings>");
    }

    protected void writeServerSettings(PrintStream out) {
        out.print("<ServerSettings>");
        out.print("<ServerVersion>");
        AbstractSoapService.writeEncoded(out, this.serverVersion);
        out.print("</ServerVersion>");
        out.print("<RecycleBinEnabled>True</RecycleBinEnabled>");
        out.print("<ServerRelativeUrl>");
        AbstractSoapService.writeEncoded(out, this.webFullUrl);
        out.print("</ServerRelativeUrl>");
        out.print("</ServerSettings>");
    }
}

