/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.lists.ViewDescription;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class AbstractViewsService
extends AbstractSoapService {
    private static final long serialVersionUID = -4196483507106061779L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractViewsService.class);
    public static final String METHODNAME_GETVIEWCOLLECTION = "GetViewCollection";
    public static final String METHODPARAMETER_LISTNAME = "listName";
    protected static final String RESPONSE_CONTENT_TYPE = "text/xml; charset=utf-8";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETVIEWCOLLECTION)) {
            this.handleGetViewCollection(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleGetViewCollection(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        Iterable<ViewDescription> payload;
        String listName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((listName = parser.getParameter(METHODPARAMETER_LISTNAME)) == null) {
            logger.error("handleGetViewCollection: Parameter \"listName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter listName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetViewCollection: listName=" + listName);
        }
        if ((payload = this.getViewCollectionResult(listName, parser, request)) == null) {
            logger.debug("handleGetViewCollection: No views for this listName available. listName=" + listName);
            SimpleSoapParser.soapErrorResponse(response, "Invalid listName.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetViewCollectionResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetViewCollectionResult>");
        out.print("<Views>");
        for (ViewDescription view : payload) {
            view.write(out, false);
        }
        out.print("</Views>");
        out.print("</GetViewCollectionResult>");
        out.print("</GetViewCollectionResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract Iterable<ViewDescription> getViewCollectionResult(String var1, SimpleSoapParser var2, HttpServletRequest var3);
}

