/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.UnsupportedEncodingException;

public class URLPathDecoder {
    private URLPathDecoder() {
    }

    public static String decode(String s, String encoding) throws UnsupportedEncodingException {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        byte[] encodedBytesSequence = null;
        int ebsPos = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%' && i + 2 < s.length()) {
                if (encodedBytesSequence == null) {
                    encodedBytesSequence = new byte[s.length() / 3];
                }
                char c1 = s.charAt(i + 1);
                char c2 = s.charAt(i + 2);
                if (URLPathDecoder.isHexDigit(c1) && URLPathDecoder.isHexDigit(c2)) {
                    encodedBytesSequence[ebsPos++] = (byte)URLPathDecoder.decodeHexChar(c1, c2);
                    i += 2;
                    continue;
                }
                if (ebsPos > 0) {
                    result.append(new String(encodedBytesSequence, 0, ebsPos, encoding));
                    ebsPos = 0;
                }
                result.append(c);
                continue;
            }
            if (ebsPos > 0) {
                result.append(new String(encodedBytesSequence, 0, ebsPos, encoding));
                ebsPos = 0;
            }
            result.append(c);
        }
        if (ebsPos > 0) {
            result.append(new String(encodedBytesSequence, 0, ebsPos, encoding));
        }
        return result.toString();
    }

    private static boolean isHexDigit(char test) {
        return test >= '0' && test <= '9' || test >= 'A' && test <= 'F' || test >= 'a' && test <= 'f';
    }

    private static char decodeHexChar(char c1, char c2) {
        if (c1 >= 'a' && c1 <= 'f') {
            c1 = (char)(65 + (c1 - 97));
        }
        int result = c1 >= 'A' ? c1 - 65 + 10 : c1 - 48;
        result *= 16;
        if (c2 >= 'a' && c2 <= 'f') {
            c2 = (char)(65 + (c2 - 97));
        }
        return (char)(result += c2 >= 'A' ? c2 - 65 + 10 : c2 - 48);
    }
}

