/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.alfresco.officeservices.IndividualResponseRuntimeException;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.URLEncoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;

public abstract class StandardHttpService
extends HttpServlet {
    private static final long serialVersionUID = -7292866879080263707L;
    private static final ServiceLogger logger = new ServiceLogger(StandardHttpService.class);
    protected ThreadLocal<SimpleDateFormat> threadLocalDateFormatHeader = new ThreadLocal();
    protected static URLEncoder urlEncoder = new URLEncoder(URLEncoder.PATH);

    protected SimpleDateFormat getThreadDateFormatHeader() {
        SimpleDateFormat result = this.threadLocalDateFormatHeader.get();
        if (result == null) {
            result = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            result.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.threadLocalDateFormatHeader.set(result);
        }
        return result;
    }

    public abstract UserData negotiateAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void requestAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void invalidateAuthentication(UserData var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    public abstract VirtualFileSystem getVirtualFileSystem(UserData var1) throws AuthenticationRequiredException;

    protected String getSitePrefix(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + request.getContextPath();
    }

    protected String preProcessRequestedPath(String requestedPath) {
        return requestedPath;
    }

    protected String getGuidForNode(VFSNode node, String sitePrefix, String path) {
        Object s = Integer.toHexString((sitePrefix + path).hashCode()).toUpperCase();
        while (((String)s).length() < 8) {
            s = "0" + (String)s;
        }
        return (String)s + "-F63E-729E-A8B4-68F52A115EB3";
    }

    protected String getEtagForNode(VFSNode node, String sitePrefix, String path) {
        return "\"{" + this.getGuidForNode(node, sitePrefix, path) + "},0\"";
    }

    protected String getResourceTagForNode(VFSNode node, String sitePrefix, String path) {
        return "rt:" + this.getGuidForNode(node, sitePrefix, path) + "@00000000000";
    }

    protected void handleUnexpectedException(String methodName, Exception e, HttpServletRequest req, HttpServletResponse resp) {
        logger.error(methodName + ": Unexpected Exception while handling request", e);
        try {
            resp.setStatus(500);
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().print("500: Internal server error.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        VFSNode node;
        Object path;
        UserData userData;
        block26: {
            block27: {
                if (logger.isTraceEnabled()) {
                    logger.traceEnter();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("doHead: negogiating authentication");
                }
                if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doHead: authentication negogiation requested immediate return.");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.traceExit();
                    }
                    return;
                }
                String pathInfo = req.getPathInfo();
                path = req.getServletPath();
                if (pathInfo != null) {
                    path = (String)path + pathInfo;
                }
                path = this.preProcessRequestedPath((String)path);
                if (logger.isDebugEnabled()) {
                    logger.debug("doHead: path=" + (String)path);
                }
                if ((node = this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 514)) != null) break block26;
                if (logger.isDebugEnabled()) {
                    logger.debug("doHead: object does not exist. path=" + (String)path);
                }
                resp.setStatus(404);
                resp.getWriter().print("404: object not found.");
                if (!logger.isTraceEnabled()) break block27;
                logger.traceExit();
            }
            this.invalidateAuthentication(userData, req, resp);
            return;
        }
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)node;
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("doHead: virtual file system returned a non-document node (i.e. a directory). path=" + (String)path);
            }
            resp.setStatus(200);
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            this.invalidateAuthentication(userData, req, resp);
            return;
        }
        try {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("doHead: mimeString=" + document.getMimeString(514));
                }
                resp.setStatus(200);
                String sitePrefix = this.getSitePrefix(req);
                resp.setHeader("Last-Modified", this.getThreadDateFormatHeader().format(document.getDateLastModified(514)));
                resp.setHeader("ETag", this.getEtagForNode(document, sitePrefix, (String)path));
                resp.setHeader("ResourceTag", this.getResourceTagForNode(document, sitePrefix, (String)path));
                resp.setContentType(document.getMimeString(514));
                resp.setContentLength((int)document.getSize(514));
            }
            catch (AuthenticationRequiredException are) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doHead: requested authentication.");
                }
                this.requestAuthentication(req, resp);
            }
            catch (IndividualResponseRuntimeException irre) {
                logger.debug("doHead: Individual Error Message Requested", irre);
                try {
                    resp.setStatus(irre.getWebdavStatus());
                    resp.setCharacterEncoding("UTF-8");
                    resp.getWriter().print(irre.getWebdavMessage());
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            catch (Exception e) {
                this.handleUnexpectedException("doHead", e, req, resp);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.invalidateAuthentication(userData, req, resp);
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block39: {
            UserData userData;
            block38: {
                VFSDocumentNode document;
                Object path;
                block37: {
                    VFSNode node;
                    block35: {
                        block36: {
                            if (logger.isTraceEnabled()) {
                                logger.traceEnter();
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("doGet: negogiating authentication");
                            }
                            if ((userData = this.negotiateAuthentication(req, resp)) == null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("doGet: authentication negogiation requested immediate return.");
                                }
                                if (logger.isTraceEnabled()) {
                                    logger.traceExit();
                                }
                                return;
                            }
                            String pathInfo = req.getPathInfo();
                            path = req.getServletPath();
                            if (pathInfo != null) {
                                path = (String)path + pathInfo;
                            }
                            path = this.preProcessRequestedPath((String)path);
                            if (logger.isDebugEnabled()) {
                                logger.debug("doGet: path=" + (String)path);
                            }
                            if ((node = this.getVirtualFileSystem(userData).getNodeByPath(userData, (String)path, 513)) != null) break block35;
                            if (logger.isDebugEnabled()) {
                                logger.debug("doGet: file does not exist. path=" + (String)path);
                            }
                            resp.setStatus(404);
                            resp.getWriter().print("404: object not found.");
                            if (!logger.isTraceEnabled()) break block36;
                            logger.traceExit();
                        }
                        this.invalidateAuthentication(userData, req, resp);
                        return;
                    }
                    document = null;
                    try {
                        document = (VFSDocumentNode)node;
                    }
                    catch (ClassCastException cce) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("doGet: virtual file system returned a non-document node (i.e. a directory). path=" + (String)path);
                        }
                        if (!this.handleNonDocumentVFSNodes(userData, node, req, resp)) {
                            logger.debug("doGet: handling of non-document node failed.");
                            resp.setStatus(404);
                            resp.getWriter().print("404: object not found.");
                        }
                        if (logger.isTraceEnabled()) {
                            logger.traceExit();
                        }
                        this.invalidateAuthentication(userData, req, resp);
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("doGet: mimeString=" + document.getMimeString(513));
                    }
                    boolean ifModifiedSince = true;
                    long ifModifiedSinceDate = req.getDateHeader("If-Modified-Since");
                    if (ifModifiedSinceDate != -1L) {
                        ifModifiedSince = document.isModifiedSince(new Date(ifModifiedSinceDate), 513);
                    }
                    boolean ifNoneMatch = true;
                    String ifNoneMatchEtag = req.getHeader("If-None-Match");
                    if (ifNoneMatchEtag != null) {
                        String thisEtag = this.getEtagForNode(document, this.getSitePrefix(req), (String)path);
                        boolean bl = ifNoneMatch = !ifNoneMatchEtag.equals(thisEtag);
                    }
                    if (ifModifiedSince && ifNoneMatch) break block37;
                    resp.setStatus(304);
                    this.invalidateAuthentication(userData, req, resp);
                    return;
                }
                long contentSize = document.getSize(513);
                List<GetRange> ranges = null;
                try {
                    ranges = this.parseRanges(req, contentSize);
                }
                catch (InvalidRangeException ire) {
                    resp.setHeader("Content-Range", "bytes */" + Long.toString(contentSize));
                    resp.sendError(416);
                    this.invalidateAuthentication(userData, req, resp);
                    return;
                }
                String sitePrefix = this.getSitePrefix(req);
                resp.setHeader("Last-Modified", this.getThreadDateFormatHeader().format(document.getDateLastModified(513)));
                resp.setHeader("ETag", this.getEtagForNode(document, sitePrefix, (String)path));
                resp.setHeader("ResourceTag", this.getResourceTagForNode(document, sitePrefix, (String)path));
                resp.setContentType(document.getMimeString(513));
                resp.setHeader("Content-Disposition", this.getContentDispositionHeader(document));
                if (ranges == null) {
                    resp.setStatus(200);
                    resp.setHeader("Content-Length", Long.toString(contentSize));
                    document.emitContent((OutputStream)resp.getOutputStream(), 513);
                    break block38;
                }
                resp.setStatus(206);
                if (ranges.size() == 1) {
                    GetRange range = ranges.get(0);
                    resp.setHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                    long length = range.end - range.start + 1L;
                    resp.setHeader("Content-Length", Long.toString(length));
                    document.emitContentRange((OutputStream)resp.getOutputStream(), range.start, range.end, false, 513);
                    break block38;
                }
                resp.setHeader("Content-Range", "bytes */" + Long.toString(contentSize));
                resp.sendError(416);
                this.invalidateAuthentication(userData, req, resp);
                return;
            }
            try {
                break block39;
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doGet: requested authentication.");
                    }
                    this.requestAuthentication(req, resp);
                }
                catch (IndividualResponseRuntimeException irre) {
                    logger.debug("doGet: Individual Error Message Requested", irre);
                    try {
                        resp.setStatus(irre.getWebdavStatus());
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().print(irre.getWebdavMessage());
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (Exception e) {
                    this.handleUnexpectedException("doGet", e, req, resp);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.invalidateAuthentication(userData, req, resp);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getContentDispositionHeader(VFSDocumentNode doc) {
        String filename = doc.getName(513);
        StringBuilder sb = new StringBuilder();
        sb.append("attachment; filename=\"");
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (this.isValidQuotedStringHeaderParamChar(c)) {
                sb.append(c);
                continue;
            }
            sb.append(" ");
        }
        sb.append("\"; filename*=UTF-8''");
        sb.append(urlEncoder.encode(filename));
        return sb.toString();
    }

    protected boolean isValidQuotedStringHeaderParamChar(char c) {
        return c < '\u0100' && c != '\u007f' && c != '\"' && c > '\u001f';
    }

    protected List<GetRange> parseRanges(HttpServletRequest request, long contentSize) throws InvalidRangeException {
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            throw new InvalidRangeException();
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<GetRange> result = new ArrayList<GetRange>();
        StringTokenizer rangeTokenizer = new StringTokenizer(rangeHeader, ",");
        while (rangeTokenizer.hasMoreTokens()) {
            String rangeDefinition = rangeTokenizer.nextToken().trim();
            GetRange currentRange = new GetRange();
            currentRange.length = contentSize;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                throw new InvalidRangeException();
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = contentSize + offset;
                    currentRange.end = contentSize - 1L;
                }
                catch (NumberFormatException e) {
                    throw new InvalidRangeException();
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : contentSize - 1L;
            }
            catch (NumberFormatException e) {
                throw new InvalidRangeException();
            }
            if (!currentRange.validate()) {
                throw new InvalidRangeException();
            }
            result.add(currentRange);
        }
        return result;
    }

    protected boolean handleNonDocumentVFSNodes(UserData userData, VFSNode node, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        return false;
    }

    protected static class InvalidRangeException
    extends Exception {
        private static final long serialVersionUID = -949259025578849159L;

        public InvalidRangeException() {
        }

        public InvalidRangeException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidRangeException(String message) {
            super(message);
        }

        public InvalidRangeException(Throwable cause) {
            super(cause);
        }
    }

    protected static class GetRange {
        public long start;
        public long end;
        public long length;

        protected GetRange() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }
}

