/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.alfresco.officeservices.AbstractCopyService;
import org.alfresco.officeservices.Base64;
import org.alfresco.officeservices.FieldInformation;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;

public abstract class StandardCopyService
extends AbstractCopyService {
    private static final long serialVersionUID = -6674774147209688382L;
    private static final ServiceLogger logger = new ServiceLogger(StandardCopyService.class);

    public abstract VirtualFileSystem getVirtualFileSystem(UserData var1) throws AuthenticationRequiredException;

    @Override
    protected void getItem(UserData userData, String filename, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getItem: filename=" + filename);
        }
        filename = this.preProcessRequestedPath(filename);
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, filename, 3);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("getItem: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getItem: document not found. filename=" + filename);
            }
            SimpleSoapParser.soapErrorResponse(response, "Invalid URL.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        List<FieldInformation> fieldInformations = this.getFieldInformations(userData, document);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetItemResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetItemResult>");
        out.print("0");
        out.print("</GetItemResult>");
        out.print("<Fields>");
        if (fieldInformations != null) {
            for (FieldInformation fieldInfo : fieldInformations) {
                fieldInfo.write(out);
            }
        }
        out.print("</Fields>");
        out.print("<Stream>");
        out.flush();
        Base64.OutputStream base64Out = new Base64.OutputStream(bos, 9);
        document.emitContent(base64Out, 3);
        base64Out.flushBase64();
        out.print("</Stream>");
        out.print("</GetItemResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType("text/xml; charset=utf-8");
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract List<FieldInformation> getFieldInformations(UserData var1, VFSDocumentNode var2);

    protected String preProcessRequestedPath(String requestedPath) {
        return requestedPath;
    }
}

