/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.URLPathDecoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class AbstractCopyService
extends AbstractSoapService {
    private static final long serialVersionUID = 4239198357820735030L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractCopyService.class);
    public static final String METHODNAME_GETITEM = "GetItem";
    public static final String METHODPARAMETER_URL = "Url";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETITEM)) {
            this.handleGetItem(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getSitePrefix(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + request.getContextPath();
    }

    protected void handleGetItem(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String url;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((url = URLPathDecoder.decode(parser.getParameter(METHODPARAMETER_URL), "UTF8")) == null) {
            logger.error("handleGetItem: Parameter \"Url\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter Url");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetItem: Parameter Url=" + url);
        }
        String baseUrl = this.getSitePrefix(request);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetItem: baseUrl=" + baseUrl);
        }
        if (url.substring(0, baseUrl.length()).equalsIgnoreCase(baseUrl) && (url = url.substring(baseUrl.length())).length() > 1 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        this.getItem(userData, url, response);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract void getItem(UserData var1, String var2, HttpServletResponse var3) throws IOException, AuthenticationRequiredException;
}

