/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebViewResourcesService
extends HttpServlet {
    private static final long serialVersionUID = 528147352679187571L;
    private static Map<String, byte[]> resourcesMap = new HashMap<String, byte[]>();
    private static final ReadWriteLock resourceMapLock = new ReentrantReadWriteLock();
    private WebApplicationContext applicationContext;

    public void init() throws ServletException {
        super.init();
        this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (this.applicationContext == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String resourcePath = req.getPathInfo();
        byte[] resource = null;
        try {
            resourceMapLock.readLock().lock();
            resource = resourcesMap.get(resourcePath);
        }
        finally {
            resourceMapLock.readLock().unlock();
        }
        if (resource == null) {
            resource = this.cacheResource(resourcePath);
        }
        if (resource == null) {
            resp.setStatus(404);
            resp.getWriter().write("404: Object Not Found");
        } else {
            resp.setStatus(200);
            resp.getOutputStream().write(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] cacheResource(String resourceLocation) throws IOException {
        if (resourceLocation == null) {
            return null;
        }
        if (!((String)(resourceLocation = StringUtils.cleanPath((String)resourceLocation))).startsWith("/")) {
            resourceLocation = "/" + (String)resourceLocation;
        }
        if (((String)resourceLocation).toUpperCase().startsWith("/WEB-INF/") || ((String)resourceLocation).startsWith("/../") || ((String)resourceLocation).indexOf(58) > 0) {
            return null;
        }
        if (!(((String)resourceLocation).startsWith("/images/") || ((String)resourceLocation).startsWith("/css/") || ((String)resourceLocation).startsWith("/js/"))) {
            return null;
        }
        Resource resource = this.applicationContext.getResource((String)resourceLocation);
        if (!resource.exists()) {
            if (((String)resourceLocation).endsWith(".gif") && ((String)resourceLocation).startsWith("/images/filetypes/")) {
                resource = this.applicationContext.getResource("/images/filetypes/_default.gif");
                if (!resource.exists()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        InputStream input = resource.getInputStream();
        byte[] result = new byte[input.available()];
        input.read(result);
        try {
            resourceMapLock.writeLock().lock();
            resourcesMap.put((String)resourceLocation, result);
        }
        finally {
            resourceMapLock.writeLock().unlock();
        }
        return result;
    }
}

