/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.module.aosmodule.vfs.DocumentNode;
import org.alfresco.module.aosmodule.vfs.FolderNode;
import org.alfresco.officeservices.StandardVersionsService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class VersionsService
extends StandardVersionsService {
    private static final long serialVersionUID = 6141598435401635384L;
    protected VirtualFileSystem vfs;
    protected AuthenticationService authenticationService;
    protected Logger logger = LoggerFactory.getLogger(VersionsService.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (VirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        ((AlfrescoVirtualFileSystem)this.vfs).prepare();
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
    }

    public void soapService(final UserData userData, final String methodName, final SimpleSoapParser parser, final HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        try {
            ((AlfrescoVirtualFileSystem)this.vfs).getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    VersionsService.super.soapService(userData, methodName, parser, request, response);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.logger.debug("Error in transaction", t);
            try {
                response.setStatus(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public VirtualFileSystem getVirtualFileSystem(UserData userData) throws AuthenticationRequiredException {
        return this.vfs;
    }

    protected String getSitePrefix(HttpServletRequest request) {
        return ((AlfrescoVirtualFileSystem)this.vfs).getSitePrefix(request);
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    }

    public String getSettingsURL(UserData userData, String baseUrl, String filename) {
        return "";
    }

    public String getListGUID(UserData userData, String filename) {
        VFSNode libraryFolder = null;
        String libraryPath = AlfrescoVirtualFileSystem.getFirstFolder(AlfrescoVirtualFileSystem.normalizePath(filename));
        if (libraryPath != null) {
            try {
                libraryFolder = this.vfs.getNodeByPath(null, libraryPath, 1);
                if (libraryFolder instanceof VFSDocumentNode) {
                    libraryFolder = null;
                }
            }
            catch (Exception e) {
                libraryFolder = null;
            }
        }
        Guid listId = libraryFolder == null ? AlfrescoVirtualFileSystem.LISTID_ROOT_DOCUMENTS : Guid.parse((String)((FolderNode)libraryFolder).getFileInfo().getNodeRef().getId());
        return listId.toString();
    }

    public boolean restoreVersion(UserData userData, VFSDocumentNode document, String fileVersion) {
        VersionService versionService = ((AlfrescoVirtualFileSystem)this.vfs).getVersionService();
        try {
            FileInfo fileInfo = ((DocumentNode)document).getFileInfo();
            VersionHistory versionHistory = ((AlfrescoVirtualFileSystem)this.vfs).getVersionService().getVersionHistory(fileInfo.getNodeRef());
            Version version = versionHistory.getVersion(fileVersion);
            versionService.revert(fileInfo.getNodeRef(), version);
            HashMap<String, String> props = new HashMap<String, String>(1, 1.0f);
            props.put("description", "");
            props.put("versionType", (String)VersionType.MAJOR);
            versionService.createVersion(fileInfo.getNodeRef(), props);
        }
        catch (Exception e) {
            this.logger.debug("Error restoring document version", (Throwable)e);
            return false;
        }
        return true;
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }
}

