/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.officeservices.AbstractSiteDataService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.vfs.VirtualFileSystem;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SiteDataService
extends AbstractSiteDataService {
    private static final long serialVersionUID = -6961083258528916518L;
    protected VirtualFileSystem vfs;
    protected AuthenticationService authenticationService;
    protected Logger logger = LoggerFactory.getLogger(SiteDataService.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (VirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        ((AlfrescoVirtualFileSystem)this.vfs).prepare();
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
    }

    public boolean getUrlSegmentsResult(String pageurl, SimpleSoapParser parser, HttpServletRequest request) {
        return false;
    }

    public void soapService(final UserData userData, final String methodName, final SimpleSoapParser parser, final HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        try {
            ((AlfrescoVirtualFileSystem)this.vfs).getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    SiteDataService.super.soapService(userData, methodName, parser, request, response);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.logger.debug("Error in transaction", t);
            try {
                response.setStatus(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }
}

