/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.aosmodule.metadata.DataModelMapper;
import org.alfresco.module.aosmodule.metadata.GuidHelper;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.module.aosmodule.vfs.DocumentNode;
import org.alfresco.module.aosmodule.vfs.FolderNode;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.URLPathDecoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.datamodel.ContentTypeDefinition;
import org.alfresco.officeservices.datamodel.ContentTypeId;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.lists.AbstractListsService;
import org.alfresco.officeservices.lists.CheckinType;
import org.alfresco.officeservices.lists.ListChanges;
import org.alfresco.officeservices.lists.ListDescription;
import org.alfresco.officeservices.lists.ListItem;
import org.alfresco.officeservices.lists.ListType;
import org.alfresco.officeservices.lists.ListUpdatesBatch;
import org.alfresco.officeservices.lists.ListsGetListContentTypeContentType;
import org.alfresco.officeservices.lists.ListsGetListContentTypesContentType;
import org.alfresco.officeservices.lists.ListsGetListList;
import org.alfresco.officeservices.lists.StandardListChanges;
import org.alfresco.officeservices.lists.UpdateListItemsResults;
import org.alfresco.officeservices.lists.ViewDescription;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;
import org.alfresco.officeservices.vfs.CheckoutResult;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ListsService
extends AbstractListsService {
    private static final long serialVersionUID = 5522867539956803717L;
    protected AlfrescoVirtualFileSystem vfs;
    protected AuthenticationService authenticationService;
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;
    protected DataModelMapper dataModelMapper;
    protected Logger logger = LoggerFactory.getLogger(ListsService.class);
    protected ThreadLocal<HttpServletRequest> currentRequest = new ThreadLocal();
    protected Map<String, FieldEvaluator> fieldEvaluators;

    public void init() throws ServletException {
        super.init();
        this.setupFieldEvaluators();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (AlfrescoVirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        this.vfs.prepare();
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
        this.namespaceService = (NamespaceService)wac.getBean("NamespaceService");
        if (this.namespaceService == null) {
            throw new ServletException("Cannot find bean NamespaceService in WebApplicationContext.");
        }
        this.dictionaryService = (DictionaryService)wac.getBean("DictionaryService");
        if (this.dictionaryService == null) {
            throw new ServletException("Cannot find bean DictionaryService in WebApplicationContext.");
        }
        this.dataModelMapper = (DataModelMapper)wac.getBean("aosServerPropertiesProvider");
        if (this.dataModelMapper == null) {
            throw new ServletException("Cannot find bean aosServerPropertiesProvider in WebApplicationContext.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void soapService(final UserData userData, final String methodName, final SimpleSoapParser parser, final HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        this.currentRequest.set(request);
        try {
            this.vfs.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ListsService.super.soapService(userData, methodName, parser, request, response);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.logger.debug("Error in transaction", t);
            try {
                response.setStatus(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.currentRequest.set(null);
        }
    }

    protected String getSitePrefix(HttpServletRequest request) {
        return this.vfs.getSitePrefix(request);
    }

    protected boolean checkoutFile(UserData userData, String documentName, boolean checkoutToLocal, String lastModified) throws AuthenticationRequiredException {
        DocumentNode document = null;
        try {
            document = (DocumentNode)this.vfs.getNodeByPath(userData, documentName, 4);
        }
        catch (ClassCastException cce) {
            this.logger.error("checkoutFile: Trying to request checkout of non-file node.");
            document = null;
        }
        if (document == null) {
            this.logger.error("checkoutFile: Path does not point to a file: documentName=" + documentName);
            return false;
        }
        return document.checkout(0, null, 4, checkoutToLocal) == CheckoutResult.OK;
    }

    protected boolean checkinFile(UserData userData, String documentName, String comment, CheckinType checkinType) throws AuthenticationRequiredException {
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.vfs.getNodeByPath(userData, documentName, 4);
        }
        catch (ClassCastException cce) {
            this.logger.error("checkintFile: Trying to request checkin of non-file node.");
            document = null;
        }
        if (document == null) {
            this.logger.error("checkinFile: Path does not point to a file: documentName=" + documentName);
            return false;
        }
        return document.checkin(comment, false, 4, checkinType);
    }

    protected boolean undoCheckOut(UserData userData, String documentName) throws AuthenticationRequiredException {
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.vfs.getNodeByPath(userData, documentName, 4);
        }
        catch (ClassCastException cce) {
            this.logger.error("undoCheckOut: Trying to request undo checkout of non-file node.");
            document = null;
        }
        if (document == null) {
            this.logger.error("undoCheckOut: Path does not point to a file: documentName=" + documentName);
            return false;
        }
        return document.uncheckout(false, 4);
    }

    protected ListsGetListList getList(UserData userData, String listName, HttpServletRequest request) {
        Guid listId = Guid.parse((String)listName);
        String sitePath = this.vfs.getSitePath(request);
        if (AlfrescoVirtualFileSystem.LISTID_ROOT_DOCUMENTS.equals((Object)listId)) {
            return new ListsGetListList(101, AlfrescoVirtualFileSystem.LISTID_ROOT_DOCUMENTS.toString(), "Documents", "List of Documents", "", sitePath);
        }
        VFSNode listNode = this.vfs.getNodeFromList(listId, null, null);
        if (listNode == null) {
            return null;
        }
        return new ListsGetListList(101, listId.toString(), listNode.getName(4), "", "", sitePath);
    }

    protected ViewDescription getView(UserData userData, String listName, String viewName, HttpServletRequest request) throws AuthenticationRequiredException {
        return null;
    }

    public List<ListDescription> getListCollection(SimpleSoapParser parser) {
        ArrayList<ListDescription> lists = new ArrayList<ListDescription>();
        try {
            VFSNode rootNode = this.vfs.getNodeByPath(null, "/", 516);
            List rootContent = rootNode.getEnumerableContainees(null, 516);
            for (VFSNode n : rootContent) {
                if (!(n instanceof FolderNode)) continue;
                String name = n.getName(516);
                Guid listId = Guid.parse((String)((FolderNode)n).getNodeRef().getId());
                HttpServletRequest request = this.currentRequest.get();
                String listWebFullUrl = request != null ? this.vfs.getSitePath(request) : "/alfresco/aos";
                ListDescription ld = new ListDescription(ListType.DOCUMENTS, listId.toString(), name, name, listWebFullUrl);
                lists.add(ld);
            }
        }
        catch (Exception e) {
            this.logger.error("getListCollection: error enumerating all top folders as document lists", (Throwable)e);
        }
        return lists;
    }

    protected boolean isWSS3List(UserData userData, String listName) {
        return true;
    }

    protected ListType getListType(UserData userData, String listName) {
        return ListType.DOCUMENTS;
    }

    protected boolean isValidListName(UserData userData, String listName) {
        return false;
    }

    protected String getAlternateServerURL(UserData userData, String listName, HttpServletRequest request) {
        return this.vfs.getSitePrefix(request);
    }

    protected String getRootFolder(UserData userData, String listName) {
        return "/";
    }

    protected ListChanges getListItemChanges(UserData userData, String listName, String since, HttpServletRequest request) throws AuthenticationRequiredException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected ListChanges getListItems(UserData userData, String listName, SoapParameter query, SoapParameter queryOptions, SoapParameter viewFields, HttpServletRequest request) throws AuthenticationRequiredException {
        List subs;
        SoapParameter Folder;
        SoapParameter Eq;
        SoapParameter Where;
        SoapParameter Query;
        Guid listId = Guid.parse((String)listName);
        String fileLeafRef = null;
        if (query != null && (Query = query.getFirstSubParameterByName("Query")) != null && (Where = Query.getFirstSubParameterByName("Where")) != null && (Eq = Where.getFirstSubParameterByName("Eq")) != null) {
            SoapParameter FieldRef = Eq.getFirstSubParameterByName("FieldRef");
            SoapParameter Value = Eq.getFirstSubParameterByName("Value");
            if (FieldRef != null && Value != null) {
                SoapParameter FieldRefName = FieldRef.getFirstSubParameterByName("Name");
                if (FieldRefName != null && FieldRefName.getValue() != null && FieldRefName.getValue().equals("FileLeafRef")) {
                    fileLeafRef = Value.getValue();
                }
                if (FieldRefName == null || FieldRefName.getValue() == null || FieldRefName.getValue().equals("FileRef")) {
                    // empty if block
                }
            }
        }
        String inFolder = null;
        SoapParameter QueryOptions = queryOptions.getFirstSubParameterByName("QueryOptions");
        if (QueryOptions != null && (Folder = QueryOptions.getFirstSubParameterByName("Folder")) != null) {
            try {
                inFolder = URLPathDecoder.decode((String)Folder.getValue(), (String)"UTF8");
            }
            catch (UnsupportedEncodingException e) {
                inFolder = Folder.getValue();
            }
        }
        ArrayList<String> requestedFields = new ArrayList<String>();
        SoapParameter vf = viewFields.getFirstSubParameterByName("ViewFields");
        if (vf != null && (subs = vf.getSubParameters()) != null) {
            for (int i = 0; i < subs.size(); ++i) {
                SoapParameter fieldRefName;
                SoapParameter field = (SoapParameter)subs.get(i);
                if (!field.getName().equals("FieldRef") || (fieldRefName = field.getFirstSubParameterByName("Name")) == null) continue;
                requestedFields.add(fieldRefName.getValue());
            }
        }
        StandardListChanges result = new StandardListChanges("0", "0");
        VFSNode node = this.vfs.getNodeFromList(listId, inFolder, fileLeafRef);
        if (node == null) {
            return result;
        }
        Object baseUrl = this.getSitePrefix(request);
        if (node instanceof VFSDocumentNode) {
            ListItem li = this.convertToListItem(node, requestedFields, inFolder, (String)baseUrl);
            if (li != null) {
                result.addModifiedListItem(li);
            }
        } else {
            String pathToLeaf = ((FolderNode)node).getRelativePath();
            if (pathToLeaf.startsWith("/")) {
                pathToLeaf = pathToLeaf.length() == 1 ? "" : pathToLeaf.substring(1);
            }
            if (pathToLeaf != null & pathToLeaf.length() > 0) {
                baseUrl = (String)baseUrl + "/" + pathToLeaf;
            }
            List content = node.getEnumerableContainees(userData, 4);
            for (VFSNode contentElement : content) {
                ListItem li = this.convertToListItem(contentElement, requestedFields, pathToLeaf, (String)baseUrl);
                if (li == null) continue;
                result.addModifiedListItem(li);
            }
        }
        return result;
    }

    protected ListItem convertToListItem(VFSNode node, ArrayList<String> requestedFields, String pathToLeaf, String baseUrl) {
        Guid itemGuid;
        FileInfo fileInfo = null;
        if (node instanceof DocumentNode) {
            fileInfo = ((DocumentNode)node).getFileInfo();
        } else if (node instanceof FolderNode) {
            fileInfo = ((FolderNode)node).getFileInfo();
        }
        if (fileInfo == null) {
            return null;
        }
        String itemId = "1";
        try {
            itemGuid = Guid.parse((String)fileInfo.getNodeRef().getId());
        }
        catch (IllegalArgumentException iae) {
            itemGuid = GuidHelper.createGuidFromStringPair(fileInfo.getNodeRef().getStoreRef().toString(), fileInfo.getNodeRef().getId(), GuidHelper.GUID_MARKER_FILEINFOLDER);
        }
        String creator = (String)fileInfo.getProperties().get(ContentModel.PROP_CREATOR);
        String modifier = (String)fileInfo.getProperties().get(ContentModel.PROP_MODIFIER);
        if (creator == null) {
            creator = "Unknown";
        }
        if (modifier == null) {
            modifier = "Unknown";
        }
        ListItem result = new ListItem(itemId, fileInfo.getModifiedDate(), fileInfo.getCreatedDate(), "1", creator, "1", modifier, "1", false);
        result.setNamedColumn("ows__Level", node instanceof DocumentNode ? (((DocumentNode)node).isCheckedOutToLocal() ? "255" : "2") : "1");
        result.setNamedColumn("ows_UniqueId", itemId + ";#" + itemGuid.toString());
        result.setNamedColumn("ows_FSObjType", itemId + ";#" + (fileInfo.isFolder() ? "1" : "0"));
        result.setNamedColumn("ows_Created_x0020_Date", itemId + ";#" + AbstractSoapService.formatDate((Date)fileInfo.getCreatedDate()));
        result.setNamedColumn("ows_ProgId", itemId + ";#");
        result.setNamedColumn("ows_FileLeafRef", itemId + ";#" + fileInfo.getName());
        result.setNamedColumn("ows_FileRef", itemId + ";#" + (String)(pathToLeaf != null && pathToLeaf.length() > 0 ? pathToLeaf + "/" : "") + fileInfo.getName());
        result.setNamedColumn("ows_Last_x0020_Modified", itemId + ";#" + AbstractSoapService.formatDate((Date)fileInfo.getModifiedDate()));
        result.setNamedColumn("ows_ServerRedirected", "0");
        for (String requestedField : requestedFields) {
            String fieldValue;
            FieldEvaluator evaluator = this.fieldEvaluators.get(requestedField);
            if (evaluator == null || (fieldValue = evaluator.getValue(node, itemId, baseUrl)) == null) continue;
            result.setNamedColumn("ows_" + requestedField, fieldValue);
        }
        return result;
    }

    protected void setupFieldEvaluators() {
        this.fieldEvaluators = new HashMap<String, FieldEvaluator>();
        this.fieldEvaluators.put("IsCheckedoutToLocal", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return itemId + ";#" + (((DocumentNode)node).isCheckedOutToLocal() ? "1" : "0");
                }
                return null;
            }
        });
        this.fieldEvaluators.put("CheckoutUser", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode && ((DocumentNode)node).isCheckedOut()) {
                    return itemId + ";#" + ((DocumentNode)node).getCheckoutOwner();
                }
                return null;
            }
        });
        this.fieldEvaluators.put("ContentType", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return ((DocumentNode)node).getContentTypeName();
                }
                return "Folder";
            }
        });
        this.fieldEvaluators.put("DocIcon", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                String name;
                int extSepPos;
                if (node instanceof DocumentNode && (extSepPos = (name = node.getName(4)).lastIndexOf(46)) >= 0 && extSepPos < name.length() - 1) {
                    return name.substring(extSepPos + 1);
                }
                return null;
            }
        });
        this.fieldEvaluators.put("ContentTypeId", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return ((DocumentNode)node).getContentTypeId().toString();
                }
                return "0x0120";
            }
        });
        this.fieldEvaluators.put("LinkFilename", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                return node.getName(4);
            }
        });
        this.fieldEvaluators.put("File_x0020_Size", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return itemId + ";#" + Long.toString(((DocumentNode)node).getSize(4));
                }
                return itemId + ";#";
            }
        });
        this.fieldEvaluators.put("File_x0020_Type", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                String name;
                int extSepPos;
                if (node instanceof DocumentNode && (extSepPos = (name = node.getName(4)).lastIndexOf(46)) >= 0 && extSepPos < name.length() - 1) {
                    return name.substring(extSepPos + 1);
                }
                return null;
            }
        });
        this.fieldEvaluators.put("EncodedAbsUrl", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                return baseUrl + "/" + node.getName(4);
            }
        });
        this.fieldEvaluators.put("FileSizeDisplay", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return Long.toString(((DocumentNode)node).getSize(4));
                }
                return null;
            }
        });
        this.fieldEvaluators.put("Created_x0020_By", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return ((DocumentNode)node).getCreator();
                }
                return null;
            }
        });
        this.fieldEvaluators.put("Modified_x0020_By", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return ((DocumentNode)node).getModifier();
                }
                return null;
            }
        });
        this.fieldEvaluators.put("PermMask", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                return "0x7fffffffffffffff";
            }
        });
        this.fieldEvaluators.put("_UIVersionString", new FieldEvaluator(){

            @Override
            public String getValue(VFSNode node, String itemId, String baseUrl) {
                if (node instanceof DocumentNode) {
                    return ((DocumentNode)node).getVersionNumber().toString();
                }
                return "1.0";
            }
        });
    }

    protected UpdateListItemsResults updateListItems(UserData userData, String listName, ListUpdatesBatch batch, HttpServletRequest request) throws AuthenticationRequiredException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected ListChanges getListChangesSinceToken(UserData userData, String listName, SoapParameter viewFields, String rowLimit, SoapParameter queryOptions, String changeToken, SoapParameter contains, HttpServletRequest request) throws AuthenticationRequiredException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected ListsGetListContentTypeContentType getListContentType(UserData userData, String listName, String contentTypeId, HttpServletRequest request) throws AuthenticationRequiredException {
        ContentTypeId cti;
        if (contentTypeId == null) {
            return null;
        }
        try {
            cti = ContentTypeId.parse((String)contentTypeId);
        }
        catch (ParseException pe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid ContentTypeId: " + contentTypeId, (Throwable)pe);
            }
            return null;
        }
        ContentTypeDefinition contentTypeDef = this.dataModelMapper.getContentTypeDefinition(cti, true);
        if (contentTypeDef == null) {
            return null;
        }
        return new ListsGetListContentTypeContentType(contentTypeDef, this.vfs.getSitePath(request) + "/Data Dictionary/AOS");
    }

    protected ListsGetListContentTypesContentType[] getListContentTypes(UserData userData, String listName, String contentTypeId, HttpServletRequest request) throws AuthenticationRequiredException {
        String scope = this.getSitePrefix(request);
        if (contentTypeId != null && contentTypeId.length() > 0) {
            return this.getListContentTypesForTypeId(contentTypeId, scope);
        }
        Collection<ContentTypeDefinition> allContentTypeDefs = this.dataModelMapper.getAllContentTypes(false, true);
        ArrayList<ListsGetListContentTypesContentType> result = new ArrayList<ListsGetListContentTypesContentType>(allContentTypeDefs.size());
        for (ContentTypeDefinition contentTypeDef : allContentTypeDefs) {
            boolean isBestMatch = contentTypeId != null && contentTypeId.equalsIgnoreCase(contentTypeDef.toString());
            result.add(new ListsGetListContentTypesContentType(contentTypeDef, isBestMatch, scope));
        }
        return result.toArray(new ListsGetListContentTypesContentType[result.size()]);
    }

    private ListsGetListContentTypesContentType[] getListContentTypesForTypeId(String contentTypeId, String scope) {
        ContentTypeId cti;
        try {
            cti = ContentTypeId.parse((String)contentTypeId);
        }
        catch (ParseException pe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid ContentTypeId: " + contentTypeId, (Throwable)pe);
            }
            return null;
        }
        ContentTypeDefinition contentTypeDef = this.dataModelMapper.getContentTypeDefinition(cti, true);
        if (contentTypeDef == null) {
            return null;
        }
        ListsGetListContentTypesContentType[] result = new ListsGetListContentTypesContentType[]{new ListsGetListContentTypesContentType(contentTypeDef, true, scope)};
        return result;
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    private static interface FieldEvaluator {
        public String getValue(VFSNode var1, String var2, String var3);
    }
}

