/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.alfresco.officeservices.URLPathDecoder;

public class ContextRootFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public String toString() {
        return "Alfresco AOS Context Root Filter";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String method;
            String requestedPath = "";
            try {
                requestedPath = URLPathDecoder.decode((String)((HttpServletRequest)request).getRequestURI(), (String)"UTF8");
                if (null == requestedPath) {
                    requestedPath = "";
                }
            }
            catch (UnsupportedEncodingException ex) {
                requestedPath = "";
            }
            String contextPath = ((HttpServletRequest)request).getContextPath();
            if (contextPath != null && requestedPath.substring(0, contextPath.length()).equals(contextPath)) {
                requestedPath = requestedPath.substring(contextPath.length());
            }
            while (requestedPath.length() > 0 && requestedPath.charAt(0) == '/') {
                requestedPath = requestedPath.substring(1);
            }
            if (requestedPath.length() == 0 && ((method = ((HttpServletRequest)request).getMethod()).equals("PROPFIND") || method.equals("OPTIONS"))) {
                RequestDispatcher rqDispatcher = request.getRequestDispatcher("/AosResponder_Context");
                if (rqDispatcher != null) {
                    rqDispatcher.forward(request, response);
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

