/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.aosmodule.metadata.DataModelMapper;
import org.alfresco.module.aosmodule.metadata.DataModelMappingConfiguration;
import org.alfresco.module.aosmodule.metadata.GuidHelper;
import org.alfresco.officeservices.datamodel.ContentTypeDefinition;
import org.alfresco.officeservices.datamodel.ContentTypeId;
import org.alfresco.officeservices.datamodel.DateFieldFormat;
import org.alfresco.officeservices.datamodel.FieldDefinition;
import org.alfresco.officeservices.datamodel.FieldValue;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class StandardDataModelMapper
implements DataModelMapper,
InitializingBean {
    public static String DEFAULT_CONTENT_TYPE_GROUP = "Alfresco Document Types";
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected DataModelMappingConfiguration dataModelMappingConfiguration;
    private Logger logger = LoggerFactory.getLogger(StandardDataModelMapper.class);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"dataModelMappingConfiguration", (Object)this.dataModelMappingConfiguration);
    }

    @Override
    public Guid getContentTypeGuid(QName name) {
        return GuidHelper.createGuidFromQname(name, GuidHelper.GUID_MARKER_CONTENTTYPE);
    }

    @Override
    public Guid getPropertyGuid(QName name) {
        return GuidHelper.createGuidFromQname(name, GuidHelper.GUID_MARKER_PROPERTY);
    }

    @Override
    public ContentTypeId getContentTypeId(QName name) {
        return ContentTypeId.DOCUMENT.getChild(this.getContentTypeGuid(name));
    }

    @Override
    public ContentTypeId getContentTypeId(NodeRef nodeRef) {
        return ContentTypeId.DOCUMENT.getChild(Guid.parse((String)nodeRef.getId()));
    }

    @Override
    public FieldDefinition convertToFieldDefinition(PropertyDefinition propDef) {
        boolean readOnly;
        if (propDef.isMultiValued()) {
            return null;
        }
        Guid id = this.getPropertyGuid(propDef.getName());
        String displayName = propDef.getTitle((MessageLookup)this.dictionaryService);
        if (displayName == null) {
            displayName = propDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        String name = StandardDataModelMapper.displayNameToXmlName(displayName);
        String description = propDef.getDescription((MessageLookup)this.dictionaryService);
        if (description == null) {
            description = "";
        }
        boolean mandatory = (readOnly = propDef.isProtected()) ? false : propDef.isMandatory();
        DataTypeDefinition dtd = propDef.getDataType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("convertToFieldDefinition(" + propDef.getName().toString() + "): id=" + String.valueOf(id) + " name=" + name + " displayName=" + displayName + " dataType=" + String.valueOf(dtd.getName()) + " mandatory=" + mandatory + " readOnly=" + readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.TEXT)) {
            Pair<ListOfValuesConstraint, Boolean> listOfValuesConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), ListOfValuesConstraint.class);
            if (listOfValuesConstraintResult.getFirst() != null) {
                if (((Boolean)listOfValuesConstraintResult.getSecond()).booleanValue()) {
                    return null;
                }
                ListOfValuesConstraint listOfValuesConstraint = (ListOfValuesConstraint)listOfValuesConstraintResult.getFirst();
                ArrayList<String> listOfDisplayLabels = new ArrayList<String>();
                for (String allowedValue : listOfValuesConstraint.getAllowedValues()) {
                    String displayLabel = listOfValuesConstraint.getDisplayLabel(allowedValue, (MessageLookup)this.dictionaryService);
                    listOfDisplayLabels.add(displayLabel);
                }
                return this.setShowIn(FieldDefinition.createChoiceFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, listOfDisplayLabels), readOnly);
            }
            Pair<StringLengthConstraint, Boolean> stringLengthConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), StringLengthConstraint.class);
            if (((Boolean)stringLengthConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            Integer minTextLength = null;
            Integer maxTextLength = null;
            if (stringLengthConstraintResult.getFirst() != null) {
                StringLengthConstraint stringLengthConstraint = (StringLengthConstraint)stringLengthConstraintResult.getFirst();
                if (stringLengthConstraint.getMinLength() != 0) {
                    minTextLength = stringLengthConstraint.getMinLength();
                }
                if (stringLengthConstraint.getMaxLength() != Integer.MAX_VALUE) {
                    maxTextLength = stringLengthConstraint.getMaxLength();
                }
            }
            return this.setShowIn(FieldDefinition.createTextFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, minTextLength, maxTextLength), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return this.setShowIn(FieldDefinition.createNoteFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.INT)) {
            int precision = 0;
            Number minValue = null;
            Number maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            } else {
                minValue = Integer.MIN_VALUE;
                maxValue = Integer.MAX_VALUE;
            }
            return this.setShowIn(FieldDefinition.createNumberFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, (int)precision, (Number)minValue, (Number)maxValue), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.LONG)) {
            int precision = 0;
            Number minValue = null;
            Number maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            } else {
                minValue = Long.MIN_VALUE;
                maxValue = Long.MAX_VALUE;
            }
            return this.setShowIn(FieldDefinition.createNumberFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, (int)precision, (Number)minValue, (Number)maxValue), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.FLOAT)) {
            int precision = 5;
            Double minValue = null;
            Double maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            }
            return this.setShowIn(FieldDefinition.createNumberFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, (int)precision, (Number)minValue, maxValue), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.DOUBLE)) {
            int precision = 10;
            Double minValue = null;
            Double maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            }
            return this.setShowIn(FieldDefinition.createNumberFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, (int)precision, (Number)minValue, maxValue), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.DATE)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return this.setShowIn(FieldDefinition.createDateTimeFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, (DateFieldFormat)DateFieldFormat.DATE_ONLY), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.DATETIME)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return this.setShowIn(FieldDefinition.createDateTimeFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly, (DateFieldFormat)DateFieldFormat.DATE_TIME), readOnly);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.BOOLEAN)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return this.setShowIn(FieldDefinition.createBooleanFieldDefinition((Guid)id, (String)name, (String)displayName, (String)description, (boolean)mandatory, (boolean)readOnly), readOnly);
        }
        return null;
    }

    private FieldDefinition setShowIn(FieldDefinition fieldDef, boolean readOnly) {
        if (readOnly) {
            fieldDef.setShowInEditForm(false);
            fieldDef.setShowInFileDlg(false);
            fieldDef.setShowInNewForm(false);
        }
        return fieldDef;
    }

    public static <T extends Constraint> Pair<T, Boolean> findConstraint(List<ConstraintDefinition> constraints, Class<T> clazz) {
        if (constraints == null) {
            return new Pair(null, (Object)Boolean.FALSE);
        }
        Constraint constraint = null;
        boolean hasOthers = false;
        for (ConstraintDefinition constraintDefinition : constraints) {
            Constraint c = constraintDefinition.getConstraint();
            if (clazz.isAssignableFrom(c.getClass())) {
                constraint = c;
                continue;
            }
            hasOthers = true;
        }
        return new Pair(constraint, (Object)hasOthers);
    }

    public static String displayNameToXmlName(String prefixString) {
        StringBuilder result = new StringBuilder(prefixString.length() * 2);
        int numChars = prefixString.length();
        for (int i = 0; i < numChars; ++i) {
            char c = prefixString.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                result.append(c);
                continue;
            }
            result.append('_');
            result.append('x');
            String hexC = Integer.toHexString(c);
            int numFill = 4 - hexC.length();
            for (int ii = 0; ii < numFill; ++ii) {
                result.append('0');
            }
            result.append(hexC);
            result.append('_');
        }
        return result.toString();
    }

    @Override
    public Collection<ContentTypeDefinition> getAllContentTypes(boolean includeFields, boolean onlyInstantiable) {
        Collection allTypesInDocumentBranch = this.dictionaryService.getSubTypes(this.dataModelMappingConfiguration.getRootDocumentType(), true);
        ArrayList<ContentTypeDefinition> result = new ArrayList<ContentTypeDefinition>(allTypesInDocumentBranch.size());
        for (QName typeName : allTypesInDocumentBranch) {
            ContentTypeDefinition ctd;
            ClassDefinition classDef;
            if (onlyInstantiable && !this.dataModelMappingConfiguration.isInstantiable(typeName) || (classDef = this.dictionaryService.getClass(typeName)) == null || (ctd = this.convertToContentTypeDefinition(classDef, includeFields, null)) == null) continue;
            result.add(ctd);
        }
        return result;
    }

    protected ContentTypeDefinition convertToContentTypeDefinition(ClassDefinition classDef, boolean includeFields, ContentTypeId overwriteTypeId) {
        ContentTypeDefinition result = new ContentTypeDefinition(overwriteTypeId != null ? overwriteTypeId : this.getContentTypeId(classDef.getName()), classDef.getTitle((MessageLookup)this.dictionaryService), DEFAULT_CONTENT_TYPE_GROUP, classDef.getDescription((MessageLookup)this.dictionaryService));
        if (includeFields) {
            this.addPropertiesToContentTypeDefinition(classDef.getProperties(), result);
        }
        return result;
    }

    protected void addPropertiesToContentTypeDefinition(Map<QName, PropertyDefinition> propDefs, ContentTypeDefinition contentType) {
        for (PropertyDefinition propDef : propDefs.values()) {
            FieldDefinition fieldDef;
            if (!this.dataModelMappingConfiguration.isPropertyMapped(propDef.getName()) || (fieldDef = this.convertToFieldDefinition(propDef)) == null) continue;
            contentType.addFieldDefinition(fieldDef);
        }
    }

    @Override
    public ContentTypeDefinition getContentTypeDefinition(ContentTypeId contentTypeId, boolean includeFields) {
        QName dictionaryBranchParent = null;
        if (!contentTypeId.isGuidBased()) {
            return null;
        }
        if (contentTypeId.getParent().equals((Object)ContentTypeId.DOCUMENT)) {
            dictionaryBranchParent = this.dataModelMappingConfiguration.getRootDocumentType();
        } else if (contentTypeId.getParent().equals((Object)ContentTypeId.FOLDER)) {
            dictionaryBranchParent = this.dataModelMappingConfiguration.getRootFolderType();
        } else {
            return null;
        }
        Guid contentTypeGuid = contentTypeId.getGuid();
        if (GuidHelper.isGuidMarkedAs(contentTypeGuid, GuidHelper.GUID_MARKER_CONTENTTYPE)) {
            return this.getContentTypeDefinitionOfDictionaryType(contentTypeGuid, dictionaryBranchParent, includeFields);
        }
        return this.getContentTypeDefinitionOfNodeRef(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, contentTypeGuid.toInnerString().toLowerCase()), includeFields);
    }

    protected ContentTypeDefinition getContentTypeDefinitionOfDictionaryType(Guid contentTypeGuid, QName dictionaryBranchParent, boolean includeFields) {
        QName typeName = this.findQNameForGuid(contentTypeGuid, dictionaryBranchParent);
        if (typeName == null) {
            return null;
        }
        ClassDefinition classDef = this.dictionaryService.getClass(typeName);
        if (classDef == null) {
            return null;
        }
        return this.convertToContentTypeDefinition(classDef, includeFields, null);
    }

    protected QName findQNameForGuid(Guid contentTypeGuid, QName dictionaryBranchParent) {
        Collection allTypesInBranch = this.dictionaryService.getSubTypes(dictionaryBranchParent, true);
        for (QName typeName : allTypesInBranch) {
            if (!contentTypeGuid.equals((Object)this.getContentTypeGuid(typeName))) continue;
            return typeName;
        }
        return null;
    }

    protected ContentTypeDefinition getContentTypeDefinitionOfNodeRef(NodeRef nodeRef, boolean includeFields) {
        Set aspectsQNames;
        QName nodeTypeQname;
        try {
            nodeTypeQname = this.nodeService.getType(nodeRef);
            aspectsQNames = this.nodeService.getAspects(nodeRef);
        }
        catch (Exception e) {
            return null;
        }
        ClassDefinition classDef = this.dictionaryService.getClass(nodeTypeQname);
        if (classDef == null) {
            return null;
        }
        ContentTypeDefinition result = this.convertToContentTypeDefinition(classDef, includeFields, this.getContentTypeId(nodeRef));
        if (includeFields) {
            for (QName aspectName : aspectsQNames) {
                AspectDefinition aspectDef;
                if (!this.dataModelMappingConfiguration.isAspectMapped(aspectName) || (aspectDef = this.dictionaryService.getAspect(aspectName)) == null) continue;
                this.addPropertiesToContentTypeDefinition(aspectDef.getProperties(), result);
            }
        }
        return result;
    }

    @Override
    public QName getAlfrescoType(ContentTypeId contentTypeId) {
        if (!contentTypeId.isGuidBased()) {
            return null;
        }
        QName dictionaryBranchParent = null;
        if (contentTypeId.getParent().equals((Object)ContentTypeId.DOCUMENT)) {
            dictionaryBranchParent = this.dataModelMappingConfiguration.getRootDocumentType();
        } else if (contentTypeId.getParent().equals((Object)ContentTypeId.FOLDER)) {
            dictionaryBranchParent = this.dataModelMappingConfiguration.getRootFolderType();
        } else {
            return null;
        }
        Guid contentTypeGuid = contentTypeId.getGuid();
        return this.findQNameForGuid(contentTypeGuid, dictionaryBranchParent);
    }

    @Override
    public Map<QName, FieldDefinition> getPropertyMapping(NodeRef nodeRef) {
        Set aspectsQNames;
        QName nodeTypeQname;
        try {
            nodeTypeQname = this.nodeService.getType(nodeRef);
            aspectsQNames = this.nodeService.getAspects(nodeRef);
        }
        catch (Exception e) {
            return null;
        }
        ClassDefinition classDef = this.dictionaryService.getClass(nodeTypeQname);
        if (classDef == null) {
            return null;
        }
        HashMap<QName, FieldDefinition> result = new HashMap<QName, FieldDefinition>();
        this.addPropertiesToMapping(classDef.getProperties(), result);
        for (QName aspectName : aspectsQNames) {
            AspectDefinition aspectDef;
            if (!this.dataModelMappingConfiguration.isAspectMapped(aspectName) || (aspectDef = this.dictionaryService.getAspect(aspectName)) == null) continue;
            this.addPropertiesToMapping(aspectDef.getProperties(), result);
        }
        return Collections.unmodifiableMap(result);
    }

    protected void addPropertiesToMapping(Map<QName, PropertyDefinition> propDefs, HashMap<QName, FieldDefinition> result) {
        for (PropertyDefinition propDef : propDefs.values()) {
            FieldDefinition fieldDef;
            if (!this.dataModelMappingConfiguration.isPropertyMapped(propDef.getName()) || (fieldDef = this.convertToFieldDefinition(propDef)) == null) continue;
            result.put(propDef.getName(), fieldDef);
        }
    }

    @Override
    public Collection<FieldValue> getFieldValues(NodeRef nodeRef) {
        Map<QName, FieldDefinition> propertyMapping = this.getPropertyMapping(nodeRef);
        if (propertyMapping == null) {
            return null;
        }
        Map alfrescoProperties = this.nodeService.getProperties(nodeRef);
        ArrayList<FieldValue> result = new ArrayList<FieldValue>(propertyMapping.size());
        for (Map.Entry<QName, FieldDefinition> mappingEntry : propertyMapping.entrySet()) {
            QName alfrescoName = mappingEntry.getKey();
            FieldDefinition fieldDef = mappingEntry.getValue();
            result.add(new FieldValue(fieldDef, alfrescoProperties.get(alfrescoName)));
        }
        return result;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public DataModelMappingConfiguration getDataModelMappingConfiguration() {
        return this.dataModelMappingConfiguration;
    }

    public void setDataModelMappingConfiguration(DataModelMappingConfiguration dataModelMappingConfiguration) {
        this.dataModelMappingConfiguration = dataModelMappingConfiguration;
    }
}

