/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.module.aosmodule.metadata.ContentFilterProcessingResult;
import org.alfresco.module.aosmodule.metadata.DataModelMappingConfiguration;
import org.alfresco.module.aosmodule.metadata.OOXMLFileProcessor;
import org.alfresco.module.aosmodule.metadata.ServerPropertiesProvider;
import org.alfresco.officeservices.datamodel.ContentTypeId;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.docproc.DocumentMetadataProcessor;
import org.alfresco.officeservices.docproc.DocumentProperty;
import org.alfresco.officeservices.docproc.ServerMetadata;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OOXMLServerPropertiesInjector
implements OOXMLFileProcessor {
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected DataModelMappingConfiguration dataModelMappingConfiguration;
    protected ServerPropertiesProvider serverPropertiesProvider;
    protected Logger logger = LoggerFactory.getLogger(OOXMLServerPropertiesInjector.class);

    @Override
    public boolean appliesTo(NodeRef nodeRef) {
        if (nodeRef == null) {
            return false;
        }
        QName nodeTypeQname = this.nodeService.getType(nodeRef);
        return this.dataModelMappingConfiguration.isTypeMapped(nodeTypeQname);
    }

    @Override
    public boolean appliesTo(OPCPackage pkg, NodeRef nodeRef) {
        return this.appliesTo(nodeRef);
    }

    @Override
    public ContentFilterProcessingResult execute(OPCPackage pkg, NodeRef nodeRef) {
        if (nodeRef == null) {
            return ContentFilterProcessingResult.UNMODIFIED;
        }
        ServerMetadata serverMetadata = this.getServerMetadata(nodeRef);
        if (serverMetadata == null) {
            return ContentFilterProcessingResult.UNMODIFIED;
        }
        try {
            DocumentMetadataProcessor.embedMetadata((OPCPackage)pkg, (ServerMetadata)serverMetadata);
        }
        catch (IOException | ParserConfigurationException | HPSFException | OpenXML4JException | XmlException | SAXException e) {
            this.logger.error("Error embedding metadata", e);
        }
        return ContentFilterProcessingResult.MODIFIED;
    }

    protected ServerMetadata getServerMetadata(NodeRef nodeRef) {
        Map<QName, DocumentProperty> properties;
        if (this.serverPropertiesProvider != null && (properties = this.serverPropertiesProvider.getServerPropertiesMapping(nodeRef)) != null) {
            QName nodeTypeQname = this.nodeService.getType(nodeRef);
            ClassDefinition classDefinition = this.dictionaryService.getClass(nodeTypeQname);
            String contentTypeName = classDefinition.getTitle((MessageLookup)this.dictionaryService);
            if (contentTypeName == null || contentTypeName.isEmpty()) {
                contentTypeName = nodeTypeQname.getLocalName();
            }
            ContentTypeId contentTypeId = ContentTypeId.DOCUMENT.getChild(Guid.parse((String)nodeRef.getId()));
            return new ServerMetadata(contentTypeName, contentTypeId.toString(), properties.values(), this.serverPropertiesProvider.getDocumentTitle(nodeRef));
        }
        return null;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DataModelMappingConfiguration getDataModelMappingConfiguration() {
        return this.dataModelMappingConfiguration;
    }

    public void setDataModelMappingConfiguration(DataModelMappingConfiguration dataModelMappingConfiguration) {
        this.dataModelMappingConfiguration = dataModelMappingConfiguration;
    }

    public ServerPropertiesProvider getServerPropertiesProvider() {
        return this.serverPropertiesProvider;
    }

    public void setServerPropertiesProvider(ServerPropertiesProvider serverPropertiesProvider) {
        this.serverPropertiesProvider = serverPropertiesProvider;
    }
}

