/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.module.aosmodule.metadata.ContentPostProcessor;
import org.alfresco.module.aosmodule.metadata.ServerPropertiesProvider;
import org.alfresco.module.aosmodule.metadata.StandardDataModelMapper;
import org.alfresco.officeservices.datamodel.DateFieldFormat;
import org.alfresco.officeservices.datamodel.FieldDefinition;
import org.alfresco.officeservices.datamodel.FieldType;
import org.alfresco.officeservices.docproc.DocumentProperty;
import org.alfresco.officeservices.docproc.PropertyFormat;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLEServerPropertiesExtractionPostProcessor
implements ContentPostProcessor {
    protected Map<QName, FieldDefinition> propertyMapping;
    protected Map<QName, DocumentProperty> before;
    protected Map<String, Object> after;
    protected String title;
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected ServerPropertiesProvider serverPropertiesProvider;
    protected static Logger logger = LoggerFactory.getLogger(OLEServerPropertiesExtractionPostProcessor.class);

    public OLEServerPropertiesExtractionPostProcessor(Map<QName, FieldDefinition> propertyMapping, Map<QName, DocumentProperty> before, Map<String, Object> after, String title, NodeService nodeService, DictionaryService dictionaryService, ServerPropertiesProvider serverPropertiesProvider) {
        this.propertyMapping = propertyMapping;
        this.before = before;
        this.after = after;
        this.title = title;
        this.nodeService = nodeService;
        this.dictionaryService = dictionaryService;
        this.serverPropertiesProvider = serverPropertiesProvider;
    }

    @Override
    public void execute(NodeRef nodeRef) {
        try {
            ClassDefinition titlePropClass;
            PropertyDefinition titlePropDef;
            HashMap<QName, Object> nodeUpdates = new HashMap<QName, Object>();
            QName titlePropertyName = this.serverPropertiesProvider.getDocumentTitlePropertyName();
            if (titlePropertyName != null && this.title != null && (titlePropDef = this.dictionaryService.getProperty(titlePropertyName)) != null && ((titlePropClass = titlePropDef.getContainerClass()).isAspect() || this.dictionaryService.isSubClass(this.nodeService.getType(nodeRef), titlePropClass.getName()))) {
                nodeUpdates.put(titlePropertyName, this.title);
            }
            for (Map.Entry<QName, FieldDefinition> mapping : this.propertyMapping.entrySet()) {
                Serializable newValue;
                QName alfrescoName = mapping.getKey();
                FieldDefinition fieldDef = mapping.getValue();
                if (fieldDef.isReadOnly()) continue;
                DocumentProperty propBefore = this.before != null ? this.before.get(alfrescoName) : null;
                boolean isNullBefore = propBefore == null || propBefore.getValue() == null;
                String formattedValueBefore = isNullBefore ? "" : propBefore.getFormattedValueString(PropertyFormat.OLE);
                Object afterValue = this.after.get(fieldDef.getDisplayName());
                if (afterValue != null && !(afterValue instanceof String)) continue;
                String formattedNewValue = (String)afterValue;
                if (formattedNewValue == null || formattedNewValue.length() == 0) {
                    if (isNullBefore) continue;
                    this.nodeService.removeProperty(nodeRef, alfrescoName);
                    continue;
                }
                if (formattedValueBefore.equals(formattedNewValue)) continue;
                try {
                    newValue = this.convertValue(formattedNewValue, fieldDef, alfrescoName);
                }
                catch (Exception e) {
                    logger.error("Cannot convert value '" + formattedNewValue + "' for property " + String.valueOf(alfrescoName), (Throwable)e);
                    continue;
                }
                nodeUpdates.put(alfrescoName, newValue);
            }
            if (!nodeUpdates.isEmpty()) {
                this.nodeService.addProperties(nodeRef, nodeUpdates);
            }
        }
        catch (Exception e) {
            logger.error("Error updating properties on node.", (Throwable)e);
        }
    }

    protected Serializable convertValue(String formattedNewValue, FieldDefinition fieldDef, QName alfrescoName) throws ParseException {
        FieldType fieldType = fieldDef.getFieldType();
        switch (fieldType) {
            case TEXT: {
                return formattedNewValue;
            }
            case NOTE: {
                return formattedNewValue;
            }
            case DATE_TIME: {
                DateFieldFormat dateFieldFormat = fieldDef.getDateFormat();
                TimeZone timeZone = TimeZone.getTimeZone("UTC");
                if (dateFieldFormat.equals((Object)DateFieldFormat.DATE_ONLY)) {
                    return ISO8601DateFormat.parse((String)formattedNewValue, (TimeZone)timeZone);
                }
                return ISO8601DateFormat.parse((String)formattedNewValue, (TimeZone)timeZone);
            }
            case CHOICE: {
                String value = null;
                PropertyDefinition propDef = this.dictionaryService.getProperty(alfrescoName);
                Pair<ListOfValuesConstraint, Boolean> listOfValuesConstraintResult = StandardDataModelMapper.findConstraint(propDef.getConstraints(), ListOfValuesConstraint.class);
                ListOfValuesConstraint listOfValuesConstraint = (ListOfValuesConstraint)listOfValuesConstraintResult.getFirst();
                if (listOfValuesConstraint != null && !((Boolean)listOfValuesConstraintResult.getSecond()).booleanValue()) {
                    for (String allowedValue : listOfValuesConstraint.getAllowedValues()) {
                        String displayLabel = listOfValuesConstraint.getDisplayLabel(allowedValue, (MessageLookup)this.dictionaryService);
                        if (!displayLabel.equals(formattedNewValue)) continue;
                        value = allowedValue;
                        break;
                    }
                }
                return value;
            }
            case BOOLEAN: {
                return Boolean.valueOf(formattedNewValue.equals("1") || formattedNewValue.equalsIgnoreCase("true"));
            }
            case NUMBER: {
                if (formattedNewValue.indexOf(46) < 0 && formattedNewValue.indexOf(44) >= 0) {
                    formattedNewValue = formattedNewValue.replace(',', '.');
                }
                DecimalFormat df = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH));
                return df.parse(formattedNewValue);
            }
        }
        throw new IllegalArgumentException("Unknown data type.");
    }
}

