/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import org.alfresco.module.aosmodule.metadata.ContentFilter;
import org.alfresco.module.aosmodule.metadata.IOContentFilterRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentFilter
implements ContentFilter {
    protected boolean inputFilter = false;
    protected boolean outputFilter = false;
    protected List<String> restrictedToMimetypes;
    protected List<String> restrictedToContentTypes;
    protected boolean includeRestrictedContentTypeChildren;
    protected NodeService nodeService;
    protected IOContentFilterRegistry registry;
    private static Logger logger = LoggerFactory.getLogger(AbstractContentFilter.class);

    @Override
    public int getMaxInputPreviewByteCount() {
        return 0;
    }

    @Override
    public boolean appliesToInput(String mimeType, PushbackInputStream pis, NodeRef nodeRef) throws IOException {
        if (mimeType != null && this.restrictedToMimetypes != null && !this.restrictedToMimetypes.contains(mimeType)) {
            return false;
        }
        if (nodeRef != null && this.restrictedToContentTypes != null) {
            if (this.nodeService == null) {
                logger.error("If a ContentFilter is configured with a restrictedToContentTypes list, you need to provide the NodeService");
                return false;
            }
            QName nodeType = this.nodeService.getType(nodeRef);
            if (!this.restrictedToContentTypes.contains(nodeType.toString())) {
                return false;
            }
        }
        return this.steamHasContent(pis);
    }

    private boolean steamHasContent(PushbackInputStream pis) throws IOException {
        byte[] test = new byte[1];
        int bytesRead = IOUtils.readFully((InputStream)pis, (byte[])test);
        if (bytesRead <= 0) {
            return false;
        }
        pis.unread(test, 0, bytesRead);
        return true;
    }

    @Override
    public boolean appliesToOutput(NodeRef nodeRef, ContentReader contentReader) {
        if (this.restrictedToMimetypes != null) {
            if (contentReader == null) {
                return false;
            }
            String contentMimeType = contentReader.getMimetype();
            if (contentMimeType == null) {
                return false;
            }
            if (!this.restrictedToMimetypes.contains(contentMimeType)) {
                return false;
            }
        }
        if (this.restrictedToContentTypes != null) {
            if (this.nodeService == null) {
                logger.error("If a ContentFilter is configured with a restrictedToContentTypes list, you need to provide the NodeService");
                return false;
            }
            QName nodeType = this.nodeService.getType(nodeRef);
            if (!this.restrictedToContentTypes.contains(nodeType.toString())) {
                return false;
            }
        }
        return true;
    }

    public final void register() {
        if (this.registry == null) {
            logger.error("AbstractContentOutputFilter cannot be registered without an IOContentFilterRegistry.");
        }
        if (this.outputFilter) {
            this.registry.registerOutputFilter(this);
        }
        if (this.inputFilter) {
            this.registry.registerInputFilter(this);
        }
    }

    public boolean isInputFilter() {
        return this.inputFilter;
    }

    public void setInputFilter(boolean inputFilter) {
        this.inputFilter = inputFilter;
    }

    public boolean isOutputFilter() {
        return this.outputFilter;
    }

    public void setOutputFilter(boolean outputFilter) {
        this.outputFilter = outputFilter;
    }

    public List<String> getRestrictedToMimetypes() {
        return this.restrictedToMimetypes;
    }

    public void setRestrictedToMimetypes(List<String> restrictedToMimetypes) {
        this.restrictedToMimetypes = restrictedToMimetypes;
    }

    public List<String> getRestrictedToContentTypes() {
        return this.restrictedToContentTypes;
    }

    public void setRestrictedToContentTypes(List<String> restrictedToContentTypes) {
        this.restrictedToContentTypes = restrictedToContentTypes;
    }

    public boolean isIncludeRestrictedContentTypeChildren() {
        return this.includeRestrictedContentTypeChildren;
    }

    public void setIncludeRestrictedContentTypeChildren(boolean includeRestrictedContentTypeChildren) {
        this.includeRestrictedContentTypeChildren = includeRestrictedContentTypeChildren;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public IOContentFilterRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IOContentFilterRegistry ioContentFilterRegistry) {
        this.registry = ioContentFilterRegistry;
    }
}

