/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.workflow;

import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;

public class WorkflowTemplate {
    protected String name;
    protected String description;
    protected String instantiationUrl;
    protected String id;
    protected String baseId;
    protected String associationData;
    protected String instantiationFormUrn;
    protected String initiationCategories;
    public static final String BASEID_APPROVAL = "c6964bff-bf8d-41ac-ad5e-b61ec111731c";
    public static final String BASEID_COLLECT_FEEDBACK = "46c389a4-6e18-476c-aa17-289b0c79fb8f";
    public static final String BASEID_COLLECT_SIGNATURES = "2f213931-3b93-4f81-b021-3022434a3114";
    public static final String FORMURN_REVIEW = "urn:schemas-microsoft-com:office:infopath:workflow:ReviewRouting-Init:$Subst:LCID;";
    public static final String FORMURN_SIGNATURES = "urn:schemas-microsoft-com:office:infopath:workflow:CollectSignatures-Init:$Subst:LCID;";
    public static final String INITIATIONCATEGORY_SIGNATURECLINTREQUIRED = "SigClientRequired";

    public WorkflowTemplate(String id, String baseId, String name, String description, String instantiationUrl, String associationData) {
        this.id = id;
        this.baseId = baseId;
        this.name = name;
        this.description = description;
        this.instantiationUrl = instantiationUrl;
        this.associationData = associationData;
    }

    public void setInstantiationFormUrn(String instantiationFormUrn) {
        this.instantiationFormUrn = instantiationFormUrn;
    }

    public void setInitiationCategories(String initiationCategories) {
        this.initiationCategories = initiationCategories;
    }

    public void write(PrintStream out) throws IOException {
        out.print("<WorkflowTemplate");
        AbstractSoapService.writeXmlAttribute(out, "Name", this.name, true);
        AbstractSoapService.writeXmlAttribute(out, "Description", this.description, true);
        AbstractSoapService.writeXmlAttribute(out, "InstantiationUrl", this.instantiationUrl, true);
        out.print(">");
        out.print("<WorkflowTemplateIdSet");
        AbstractSoapService.writeXmlAttribute(out, "TemplateId", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "BaseId", this.baseId, true);
        out.print("/>");
        if (this.associationData != null) {
            out.print("<AssociationData>");
            out.print("<string>");
            AbstractSoapService.writeEncoded2(out, this.associationData);
            out.print("</string>");
            out.print("</AssociationData>");
        }
        out.print("<Metadata>");
        if (this.initiationCategories != null) {
            out.print("<InitiationCategories>");
            out.print("<string>");
            AbstractSoapService.writeEncoded2(out, this.initiationCategories);
            out.print("</string>");
            out.print("</InitiationCategories>");
        }
        out.print("<Instantiation_FormURN>");
        out.print("<string>");
        AbstractSoapService.writeEncoded2(out, this.instantiationFormUrn);
        out.print("</string>");
        out.print("</Instantiation_FormURN>");
        out.print("</Metadata>");
        out.print("</WorkflowTemplate>");
    }
}

