/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.workflow;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.workflow.WorkflowTemplate;

public class WorkflowData {
    protected String siteTitle;
    protected String siteUrl;
    protected String listTitle;
    protected String listUrl;
    protected List<WorkflowTemplate> workflowTemplates;

    public WorkflowData(String siteTitle, String siteUrl, String listTitle, String listUrl) {
        this.siteTitle = siteTitle;
        this.siteUrl = siteUrl;
        this.listTitle = listTitle;
        this.listUrl = listUrl;
        this.workflowTemplates = new ArrayList<WorkflowTemplate>();
    }

    public void addWorkflowTemplate(WorkflowTemplate template) {
        this.workflowTemplates.add(template);
    }

    public void write(PrintStream out) throws IOException {
        out.print("<WorkflowData>");
        out.print("<ToDoData>");
        out.print("</ToDoData>");
        out.print("<TemplateData>");
        out.print("<Web");
        AbstractSoapService.writeXmlAttribute(out, "Title", this.siteTitle, true);
        AbstractSoapService.writeXmlAttribute(out, "Url", this.siteUrl, true);
        out.print("/>");
        out.print("<List");
        AbstractSoapService.writeXmlAttribute(out, "Title", this.listTitle, true);
        AbstractSoapService.writeXmlAttribute(out, "Url", this.listUrl, true);
        out.print("/>");
        out.print("<WorkflowTemplates>");
        for (WorkflowTemplate template : this.workflowTemplates) {
            template.write(out);
        }
        out.print("</WorkflowTemplates>");
        out.print("</TemplateData>");
        out.print("<ActiveWorkflowsData>");
        out.print("<Workflows>");
        out.print("</Workflows>");
        out.print("</ActiveWorkflowsData>");
        out.print("<DefaultWorkflows>");
        out.print("</DefaultWorkflows>");
        out.print("</WorkflowData>");
    }
}

