/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.workflow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;
import org.alfresco.officeservices.workflow.WorkflowData;

public abstract class AbstractWorkflowService
extends AbstractSoapService {
    private static final long serialVersionUID = -7888454009053719619L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractWorkflowService.class);
    public static final String METHODNAME_GETWORKFLOWDATAFORITEM = "GetWorkflowDataForItem";
    public static final String METHODNAME_STARTWORKFLOW = "StartWorkflow";
    public static final String METHODPARAMETER_ITEM = "item";
    public static final String METHODPARAMETER_TEMPLATEID = "templateId";
    public static final String METHODPARAMETER_WORKFLOWPARAMETERS = "workflowParameters";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETWORKFLOWDATAFORITEM)) {
            this.handleGetWorkflowDataForItem(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_STARTWORKFLOW)) {
            this.handleStartWorkflow(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleGetWorkflowDataForItem(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        WorkflowData workflowData;
        String item;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((item = parser.getParameter(METHODPARAMETER_ITEM)) == null) {
            logger.error("handleGetWorkflowDataForItem: Parameter \"item\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter item");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetWorkflowDataForItem: item=" + item);
        }
        if ((workflowData = this.getWorkflowDataForItem(item, userData, parser, request)) == null) {
            response.setStatus(404);
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetWorkflowDataForItemResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/workflow/\">");
        out.print("<GetWorkflowDataForItemResult>");
        workflowData.write(out);
        out.print("</GetWorkflowDataForItemResult>");
        out.print("</GetWorkflowDataForItemResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType("text/xml; charset=utf-8");
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract WorkflowData getWorkflowDataForItem(String var1, UserData var2, SimpleSoapParser var3, HttpServletRequest var4);

    protected void handleStartWorkflow(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        boolean started;
        String item;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((item = parser.getParameter(METHODPARAMETER_ITEM)) == null) {
            logger.error("handleStartWorkflow: Parameter \"item\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter item");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String templateId = parser.getParameter(METHODPARAMETER_TEMPLATEID);
        if (templateId == null) {
            logger.error("handleStartWorkflow: Parameter \"templateId\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter templateId");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        SoapParameter workflowParameters = parser.getSoapParameter(METHODPARAMETER_WORKFLOWPARAMETERS);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetWorkflowDataForItem: item=" + item);
            logger.debug("handleGetWorkflowDataForItem: templateId=" + templateId);
        }
        if (!(started = this.startWorkflow(item, templateId, workflowParameters, userData, parser, request))) {
            SimpleSoapParser.soapErrorResponse(response, "Error starting workflow");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<StartWorkflowResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/workflow/\">");
        out.print("<StartWorkflowResult>");
        out.print("</StartWorkflowResult>");
        out.print("</StartWorkflowResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType("text/xml; charset=utf-8");
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract boolean startWorkflow(String var1, String var2, SoapParameter var3, UserData var4, SimpleSoapParser var5, HttpServletRequest var6);
}

