/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.officeservices.AbstractSoapService;

public class ListItem {
    protected String id;
    protected Date dateLastModifiedUTC;
    protected Date dateCreatedUTC;
    protected String createdByUserName;
    protected String createdByUserId;
    protected String lastModifiedByUserId;
    protected String lastModifiedByUserName;
    protected String version;
    protected boolean hasAttachments;
    protected Map<String, String> data = new LinkedHashMap<String, String>();

    public ListItem(String id, Date dateLastModifiedUTC, Date dateCreatedUTC, String createdByUserId, String createdByUserName, String lastModifiedByUserId, String lastModifiedByUserName, String version, boolean hasAttachments) {
        this.id = id;
        this.dateLastModifiedUTC = dateLastModifiedUTC;
        this.dateCreatedUTC = dateCreatedUTC;
        this.createdByUserName = createdByUserName;
        this.createdByUserId = createdByUserId;
        this.lastModifiedByUserId = lastModifiedByUserId;
        this.lastModifiedByUserName = lastModifiedByUserName;
        this.version = version;
        this.hasAttachments = hasAttachments;
    }

    public void write(PrintStream out, boolean doubleQuoted, boolean defineNamespace) throws IOException {
        out.print("<z:row");
        AbstractSoapService.writeXmlAttribute(out, "ows_ID", this.id, doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows_Modified", AbstractSoapService.formatDate(this.dateLastModifiedUTC), doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows_Created", AbstractSoapService.formatDate(this.dateCreatedUTC), doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows_Author", this.createdByUserId + ";#" + this.createdByUserName, doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows_Editor", this.lastModifiedByUserId + ";#" + this.lastModifiedByUserName, doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows_owshiddenversion", this.version, doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows_Attachments", this.hasAttachments ? "-1" : "0", doubleQuoted);
        AbstractSoapService.writeXmlAttribute(out, "ows__ModerationStatus", "0", doubleQuoted);
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null || value == null) continue;
            if (name.equals("ows_Title")) {
                AbstractSoapService.writeXmlAttribute(out, "ows_Title", value, doubleQuoted);
                AbstractSoapService.writeXmlAttribute(out, "ows_LinkTitleNoMenu", value, doubleQuoted);
                AbstractSoapService.writeXmlAttribute(out, "ows_LinkTitle", value, doubleQuoted);
                AbstractSoapService.writeXmlAttribute(out, "ows_SelectTitle", this.id, doubleQuoted);
                continue;
            }
            AbstractSoapService.writeXmlAttribute(out, name, value, doubleQuoted);
        }
        if (defineNamespace) {
            out.print(" xmlns:z=\"#RowsetSchema\"");
        }
        out.print(" />");
    }

    public void setNamedColumn(String colName, String value) {
        this.data.put(colName, value);
    }

    public String getNamedColumn(String colName) {
        return this.data.get(colName);
    }

    public Date getDateLastModifiedUTC() {
        return this.dateLastModifiedUTC;
    }

    public void setDateLastModifiedUTC(Date dateLastModifiedUTC) {
        this.dateLastModifiedUTC = dateLastModifiedUTC;
    }

    public Date getDateCreatedUTC() {
        return this.dateCreatedUTC;
    }

    public void setDateCreatedUTC(Date dateCreatedUTC) {
        this.dateCreatedUTC = dateCreatedUTC;
    }

    public String getCreatedByUserName() {
        return this.createdByUserName;
    }

    public void setCreatedByUserName(String createdByUserName) {
        this.createdByUserName = createdByUserName;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public String getLastModifiedByUserId() {
        return this.lastModifiedByUserId;
    }

    public void setLastModifiedByUserId(String lastModifiedByUserId) {
        this.lastModifiedByUserId = lastModifiedByUserId;
    }

    public String getLastModifiedByUserName() {
        return this.lastModifiedByUserName;
    }

    public void setLastModifiedByUserName(String lastModifiedByUserName) {
        this.lastModifiedByUserName = lastModifiedByUserName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isHasAttachments() {
        return this.hasAttachments;
    }

    public void setHasAttachments(boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }
}

