/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.datamodel;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Locale;
import org.alfresco.officeservices.datamodel.DateFieldFormat;
import org.alfresco.officeservices.datamodel.FieldType;
import org.alfresco.officeservices.datamodel.Guid;

public class FieldDefinition {
    private Guid id;
    private String name;
    private FieldType fieldType;
    private String displayName;
    private String description;
    private boolean mandatory;
    private boolean readOnly;
    private Integer minTextLength;
    private Integer maxTextLength;
    private Number minValue;
    private Number maxValue;
    private Iterable<String> choices;
    private int decimals;
    private DateFieldFormat dateFieldFormat;
    private String defaultValue;
    private boolean showInNewForm = true;
    private boolean showInFileDlg = true;
    private boolean showInEditForm = true;

    private FieldDefinition(Guid id, String name, FieldType fieldType, String displayName, String description, boolean mandatory, boolean readOnly, Integer minTextLength, Integer maxTextLength, Number minValue, Number maxValue, Iterable<String> choices, int decimals, DateFieldFormat dateFieldFormat) {
        this.id = id;
        this.name = name;
        this.fieldType = fieldType;
        this.displayName = displayName;
        this.description = description;
        this.mandatory = mandatory;
        this.readOnly = readOnly;
        this.minTextLength = minTextLength;
        this.maxTextLength = maxTextLength;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.choices = choices;
        this.decimals = decimals;
        this.dateFieldFormat = dateFieldFormat;
    }

    public static FieldDefinition createTextFieldDefinition(Guid id, String name, String displayName, String description, boolean mandatory, boolean readOnly, Integer minTextLength, Integer maxTextLength) {
        if (id == null) {
            throw new IllegalArgumentException("ID is required.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (displayName == null) {
            displayName = name;
        }
        if (description == null) {
            description = "";
        }
        return new FieldDefinition(id, name, FieldType.TEXT, displayName, description, mandatory, readOnly, minTextLength, maxTextLength, null, null, null, -1, null);
    }

    public static FieldDefinition createNoteFieldDefinition(Guid id, String name, String displayName, String description, boolean mandatory, boolean readOnly) {
        if (id == null) {
            throw new IllegalArgumentException("ID is required.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (displayName == null) {
            displayName = name;
        }
        if (description == null) {
            description = "";
        }
        return new FieldDefinition(id, name, FieldType.NOTE, displayName, description, mandatory, readOnly, null, null, null, null, null, -1, null);
    }

    public static FieldDefinition createDateTimeFieldDefinition(Guid id, String name, String displayName, String description, boolean mandatory, boolean readOnly, DateFieldFormat dateFieldFormat) {
        if (id == null) {
            throw new IllegalArgumentException("ID is required.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (displayName == null) {
            displayName = name;
        }
        if (description == null) {
            description = "";
        }
        if (dateFieldFormat == null) {
            throw new IllegalArgumentException("DateFieldFormat is required.");
        }
        return new FieldDefinition(id, name, FieldType.DATE_TIME, displayName, description, mandatory, readOnly, null, null, null, null, null, -1, dateFieldFormat);
    }

    public static FieldDefinition createChoiceFieldDefinition(Guid id, String name, String displayName, String description, boolean mandatory, boolean readOnly, Iterable<String> choices) {
        if (id == null) {
            throw new IllegalArgumentException("ID is required.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (displayName == null) {
            displayName = name;
        }
        if (description == null) {
            description = "";
        }
        if (choices == null) {
            throw new IllegalArgumentException("Choices is required.");
        }
        return new FieldDefinition(id, name, FieldType.CHOICE, displayName, description, mandatory, readOnly, null, null, null, null, choices, -1, null);
    }

    public static FieldDefinition createBooleanFieldDefinition(Guid id, String name, String displayName, String description, boolean mandatory, boolean readOnly) {
        if (id == null) {
            throw new IllegalArgumentException("ID is required.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (displayName == null) {
            displayName = name;
        }
        if (description == null) {
            description = "";
        }
        return new FieldDefinition(id, name, FieldType.BOOLEAN, displayName, description, mandatory, readOnly, null, null, null, null, null, -1, null);
    }

    public static FieldDefinition createNumberFieldDefinition(Guid id, String name, String displayName, String description, boolean mandatory, boolean readOnly, int decimals, Number minValue, Number maxValue) {
        if (id == null) {
            throw new IllegalArgumentException("ID is required.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (displayName == null) {
            displayName = name;
        }
        if (description == null) {
            description = "";
        }
        if (decimals < 0) {
            throw new IllegalArgumentException("Decimals must be >= 0.");
        }
        return new FieldDefinition(id, name, FieldType.NUMBER, displayName, description, mandatory, readOnly, null, null, minValue, maxValue, null, decimals, null);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setShowInNewForm(boolean flag) {
        this.showInNewForm = flag;
    }

    public void setShowInFileDlg(boolean flag) {
        this.showInFileDlg = flag;
    }

    public void setShowInEditForm(boolean flag) {
        this.showInEditForm = flag;
    }

    public Guid getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Integer getMinTextLength() {
        return this.minTextLength;
    }

    public Integer getMaxTextLength() {
        return this.maxTextLength;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public Iterable<String> getChoices() {
        return this.choices;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public DateFieldFormat getDateFormat() {
        return this.dateFieldFormat;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isShowInNewForm() {
        return this.showInNewForm;
    }

    public boolean isShowInFileDlg() {
        return this.showInFileDlg;
    }

    public boolean isShowInEditForm() {
        return this.showInEditForm;
    }

    protected String formatNumberValue(Number nbr) {
        StringBuffer result = new StringBuffer();
        DecimalFormat df = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH));
        df.setGroupingUsed(false);
        df.setMinimumIntegerDigits(1);
        df.setMinimumFractionDigits(this.decimals);
        df.setMaximumFractionDigits(this.decimals);
        df.format(nbr, result, new FieldPosition(1));
        return result.toString();
    }

    public String getFormattedMinValueString() {
        if (this.minValue == null) {
            return "";
        }
        return this.formatNumberValue(this.minValue);
    }

    public String getFormattedMaxValueString() {
        if (this.maxValue == null) {
            return "";
        }
        return this.formatNumberValue(this.maxValue);
    }
}

